/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.autoconfigure.mcp.client;

import com.alibaba.cloud.ai.autoconfigure.mcp.client.NacosMcpAutoConfiguration;
import com.alibaba.cloud.ai.autoconfigure.mcp.client.NacosMcpSseClientProperties;
import com.alibaba.cloud.ai.mcp.discovery.client.transport.LoadbalancedMcpAsyncClient;
import com.alibaba.cloud.ai.mcp.discovery.client.transport.LoadbalancedMcpSyncClient;
import com.alibaba.cloud.ai.mcp.nacos.NacosMcpProperties;
import com.alibaba.cloud.ai.mcp.nacos.service.NacosMcpOperationService;
import io.modelcontextprotocol.spec.McpSchema;
import java.util.ArrayList;
import java.util.List;
import org.springframework.ai.mcp.client.autoconfigure.McpClientAutoConfiguration;
import org.springframework.ai.mcp.client.autoconfigure.properties.McpClientCommonProperties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={NacosMcpAutoConfiguration.class, McpClientAutoConfiguration.class})
@ConditionalOnClass(value={McpSchema.class})
@EnableConfigurationProperties(value={McpClientCommonProperties.class, NacosMcpProperties.class, NacosMcpSseClientProperties.class})
@ConditionalOnProperty(prefix="spring.ai.alibaba.mcp.nacos.client", name={"enabled"}, havingValue="true", matchIfMissing=false)
public class NacosMcpClientAutoConfiguration {
    @Bean
    @ConditionalOnProperty(prefix="spring.ai.mcp.client", name={"type"}, havingValue="SYNC", matchIfMissing=true)
    public List<LoadbalancedMcpSyncClient> loadbalancedMcpSyncClientList(ObjectProvider<NacosMcpOperationService> nacosMcpOperationServiceProvider, NacosMcpSseClientProperties nacosMcpSseClientProperties, ApplicationContext applicationContext) {
        NacosMcpOperationService nacosMcpOperationService = (NacosMcpOperationService)nacosMcpOperationServiceProvider.getObject();
        ArrayList<LoadbalancedMcpSyncClient> loadbalancedMcpSyncClients = new ArrayList<LoadbalancedMcpSyncClient>();
        for (NacosMcpSseClientProperties.NacosSseParameters nacosSseParameters : nacosMcpSseClientProperties.getConnections().values()) {
            LoadbalancedMcpSyncClient loadbalancedMcpSyncClient = LoadbalancedMcpSyncClient.builder().serverName(nacosSseParameters.serviceName()).version(nacosSseParameters.version()).nacosMcpOperationService(nacosMcpOperationService).applicationContext(applicationContext).build();
            loadbalancedMcpSyncClient.init();
            loadbalancedMcpSyncClient.subscribe();
            loadbalancedMcpSyncClients.add(loadbalancedMcpSyncClient);
        }
        return loadbalancedMcpSyncClients;
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.ai.mcp.client", name={"type"}, havingValue="ASYNC")
    public List<LoadbalancedMcpAsyncClient> loadbalancedMcpAsyncClientList(ObjectProvider<NacosMcpOperationService> nacosMcpOperationServiceProvider, NacosMcpSseClientProperties nacosMcpSseClientProperties, ApplicationContext applicationContext) {
        NacosMcpOperationService nacosMcpOperationService = (NacosMcpOperationService)nacosMcpOperationServiceProvider.getObject();
        ArrayList<LoadbalancedMcpAsyncClient> loadbalancedMcpAsyncClients = new ArrayList<LoadbalancedMcpAsyncClient>();
        for (NacosMcpSseClientProperties.NacosSseParameters nacosSseParameters : nacosMcpSseClientProperties.getConnections().values()) {
            LoadbalancedMcpAsyncClient loadbalancedMcpAsyncClient = LoadbalancedMcpAsyncClient.builder().serverName(nacosSseParameters.serviceName()).version(nacosSseParameters.version()).nacosMcpOperationService(nacosMcpOperationService).applicationContext(applicationContext).build();
            loadbalancedMcpAsyncClient.init();
            loadbalancedMcpAsyncClient.subscribe();
            loadbalancedMcpAsyncClients.add(loadbalancedMcpAsyncClient);
        }
        return loadbalancedMcpAsyncClients;
    }
}

