/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.autoconfigure.mcp.tracing;

import com.alibaba.cloud.ai.mcp.common.tracing.McpTraceExchangeFilterFunction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;

@AutoConfiguration
@ConditionalOnClass(value={ExchangeFilterFunction.class})
public class McpTracingAutoConfiguration {
    @Autowired
    private ApplicationContext applicationContext;

    @Bean(name={"mcpTraceExchangeFilterFunction"})
    @ConditionalOnClass(name={"io.micrometer.tracing.Tracer"})
    public McpTraceExchangeFilterFunction mcpTraceExchangeFilterFunction() {
        try {
            Object tracer = this.applicationContext.getBean("tracer");
            return new McpTraceExchangeFilterFunction(tracer);
        }
        catch (Exception e) {
            try {
                Class<?> tracerClass = Class.forName("io.micrometer.tracing.Tracer");
                Object tracer = this.applicationContext.getBean(tracerClass);
                return new McpTraceExchangeFilterFunction(tracer);
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to create MCP trace filter: Tracer bean not found", ex);
            }
        }
    }
}

