/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.node;

import com.alibaba.cloud.ai.graph.OverAllState;
import com.alibaba.cloud.ai.model.execution.ExecutionStep;
import com.alibaba.cloud.ai.model.execution.Plan;
import com.alibaba.cloud.ai.node.AbstractPlanBasedNode;
import com.alibaba.cloud.ai.util.StateUtils;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.converter.BeanOutputConverter;
import org.springframework.core.ParameterizedTypeReference;

public class PlanExecutorNode
extends AbstractPlanBasedNode {
    private static final Logger logger = LoggerFactory.getLogger(PlanExecutorNode.class);
    private static final Set<String> SUPPORTED_NODES = Set.of("SQL_EXECUTE_NODE", "PYTHON_GENERATE_NODE", "REPORT_GENERATOR_NODE");
    private final BeanOutputConverter<Plan> converter = new BeanOutputConverter((ParameterizedTypeReference)new ParameterizedTypeReference<Plan>(){});

    public Map<String, Object> apply(OverAllState state) throws Exception {
        Plan plan;
        this.logNodeEntry();
        String plannerOutput = StateUtils.getStringValue(state, "PLANNER_NODE_OUTPUT");
        try {
            plan = (Plan)this.converter.convert(plannerOutput);
            if (plan == null || plan.getExecutionPlan() == null || plan.getExecutionPlan().isEmpty()) {
                return this.buildValidationResult(state, false, "Validation failed: The generated plan is empty or has no execution steps.");
            }
            for (ExecutionStep step : plan.getExecutionPlan()) {
                if (step.getToolToUse() == null || !SUPPORTED_NODES.contains(step.getToolToUse())) {
                    return this.buildValidationResult(state, false, "Validation failed: Plan contains an invalid tool name: '" + step.getToolToUse() + "' in step " + step.getStep());
                }
                if (step.getToolParameters() != null) continue;
                return this.buildValidationResult(state, false, "Validation failed: Tool parameters are missing for step " + step.getStep());
            }
            logger.info("Plan validation successful.");
        }
        catch (Exception e) {
            logger.error("Plan validation failed due to a parsing error.", (Throwable)e);
            return this.buildValidationResult(state, false, "Validation failed: The plan is not a valid JSON structure. Error: " + e.getMessage());
        }
        plan = this.getPlan(state);
        Integer currentStep = this.getCurrentStepNumber(state);
        List<ExecutionStep> executionPlan = plan.getExecutionPlan();
        if (currentStep > executionPlan.size()) {
            logger.info("Plan completed, current step: {}, total steps: {}", (Object)currentStep, (Object)executionPlan.size());
            return Map.of("PLAN_CURRENT_STEP", 1, "PLAN_NEXT_NODE", "REPORT_GENERATOR_NODE", "PLAN_VALIDATION_STATUS", true);
        }
        ExecutionStep executionStep = executionPlan.get(currentStep - 1);
        String toolToUse = executionStep.getToolToUse();
        return this.determineNextNode(toolToUse);
    }

    private Map<String, Object> determineNextNode(String toolToUse) {
        if (SUPPORTED_NODES.contains(toolToUse)) {
            logger.info("Determined next execution node: {}", (Object)toolToUse);
            return Map.of("PLAN_NEXT_NODE", toolToUse, "PLAN_VALIDATION_STATUS", true);
        }
        return Map.of("PLAN_VALIDATION_STATUS", false, "PLAN_VALIDATION_ERROR", "Unsupported node type: " + toolToUse);
    }

    private Map<String, Object> buildValidationResult(OverAllState state, boolean isValid, String errorMessage) {
        if (isValid) {
            return Map.of("PLAN_VALIDATION_STATUS", true);
        }
        int repairCount = StateUtils.getObjectValue(state, "PLAN_REPAIR_COUNT", Integer.class, 0);
        return Map.of("PLAN_VALIDATION_STATUS", false, "PLAN_VALIDATION_ERROR", errorMessage, "PLAN_REPAIR_COUNT", repairCount + 1);
    }
}

