/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.service.analytic;

import com.alibaba.cloud.ai.annotation.ConditionalOnADBEnabled;
import com.alibaba.cloud.ai.request.SearchRequest;
import com.alibaba.cloud.ai.service.base.BaseVectorStoreService;
import com.alibaba.cloud.ai.vectorstore.analyticdb.AnalyticDbVectorStoreProperties;
import com.aliyun.gpdb20160503.Client;
import com.aliyun.gpdb20160503.models.QueryCollectionDataRequest;
import com.aliyun.gpdb20160503.models.QueryCollectionDataResponse;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.ai.document.Document;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnADBEnabled
public class AnalyticVectorStoreService
extends BaseVectorStoreService {
    private static final String CONTENT_FIELD_NAME = "content";
    private static final String METADATA_FIELD_NAME = "metadata";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @Autowired
    @Qualifier(value="dashscopeEmbeddingModel")
    private EmbeddingModel embeddingModel;
    @Autowired
    private AnalyticDbVectorStoreProperties analyticDbVectorStoreProperties;
    @Autowired
    private Client client;

    @Override
    protected EmbeddingModel getEmbeddingModel() {
        return this.embeddingModel;
    }

    @Override
    public List<Document> searchWithVectorType(SearchRequest searchRequestDTO) {
        String filter = String.format("jsonb_extract_path_text(metadata, 'vectorType') = '%s'", searchRequestDTO.getVectorType());
        QueryCollectionDataRequest request = this.buildBaseRequest(searchRequestDTO).setFilter(filter);
        return this.executeQuery(request);
    }

    @Override
    public List<Document> searchWithFilter(SearchRequest searchRequestDTO) {
        QueryCollectionDataRequest request = this.buildBaseRequest(searchRequestDTO).setFilter(searchRequestDTO.getFilterFormatted());
        return this.executeQuery(request);
    }

    private QueryCollectionDataRequest buildBaseRequest(SearchRequest searchRequestDTO) {
        QueryCollectionDataRequest queryCollectionDataRequest = new QueryCollectionDataRequest().setDBInstanceId(this.analyticDbVectorStoreProperties.getDbInstanceId()).setRegionId(this.analyticDbVectorStoreProperties.getRegionId()).setNamespace(this.analyticDbVectorStoreProperties.getNamespace()).setNamespacePassword(this.analyticDbVectorStoreProperties.getNamespacePassword()).setCollection(this.analyticDbVectorStoreProperties.getCollectName()).setIncludeValues(Boolean.valueOf(false)).setMetrics(this.analyticDbVectorStoreProperties.getMetrics()).setTopK(Long.valueOf(searchRequestDTO.getTopK()));
        if (searchRequestDTO.getQuery() != null) {
            queryCollectionDataRequest.setVector(this.embedDouble(searchRequestDTO.getQuery()));
            queryCollectionDataRequest.setContent(searchRequestDTO.getQuery());
        }
        return queryCollectionDataRequest;
    }

    private List<Document> executeQuery(QueryCollectionDataRequest request) {
        try {
            QueryCollectionDataResponse response = this.client.queryCollectionData(request);
            return this.parseDocuments(response);
        }
        catch (Exception e) {
            throw new RuntimeException("\u5411\u91cf\u6570\u636e\u5e93\u67e5\u8be2\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    private List<Document> parseDocuments(QueryCollectionDataResponse response) throws Exception {
        return response.getBody().getMatches().getMatch().stream().filter(match -> match.getScore() == null || match.getScore() > 0.1 || match.getScore() == 0.0).map(match -> {
            Map metadata = match.getMetadata();
            try {
                Map metadataJson = (Map)OBJECT_MAPPER.readValue((String)metadata.get(METADATA_FIELD_NAME), (TypeReference)new TypeReference<HashMap<String, Object>>(){});
                metadataJson.put("score", match.getScore());
                return new Document(match.getId(), (String)metadata.get(CONTENT_FIELD_NAME), metadataJson);
            }
            catch (Exception e) {
                throw new RuntimeException("\u89e3\u6790\u5143\u6570\u636e\u5931\u8d25: " + e.getMessage(), e);
            }
        }).collect(Collectors.toList());
    }
}

