/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.service.base;

import com.alibaba.cloud.ai.request.SchemaInitRequest;
import com.alibaba.cloud.ai.request.SearchRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.springframework.ai.document.Document;
import org.springframework.ai.embedding.EmbeddingModel;

public abstract class BaseVectorStoreService {
    protected abstract EmbeddingModel getEmbeddingModel();

    public List<Double> embedDouble(String text) {
        return this.convertToDoubleList(this.getEmbeddingModel().embed(text));
    }

    public Boolean schema(SchemaInitRequest schemaInitRequest) throws Exception {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public List<Float> embedFloat(String text) {
        return this.convertToFloatList(this.getEmbeddingModel().embed(text));
    }

    public List<Document> getDocuments(String query, String vectorType) {
        SearchRequest request = new SearchRequest();
        request.setQuery(query);
        request.setVectorType(vectorType);
        request.setTopK(100);
        return new ArrayList<Document>(this.searchWithVectorType(request));
    }

    public List<Document> getDocumentsForAgent(String agentId, String query, String vectorType) {
        return this.getDocuments(query, vectorType);
    }

    public abstract List<Document> searchWithVectorType(SearchRequest var1);

    public abstract List<Document> searchWithFilter(SearchRequest var1);

    public List<Document> searchTableByNameAndVectorType(SearchRequest searchRequestDTO) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    protected List<Double> convertToDoubleList(float[] array) {
        return IntStream.range(0, array.length).mapToDouble(i -> array[i]).boxed().collect(Collectors.toList());
    }

    protected List<Float> convertToFloatList(float[] array) {
        return IntStream.range(0, array.length).mapToObj(i -> Float.valueOf(array[i])).collect(Collectors.toList());
    }
}

