/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.service.code;

import com.alibaba.cloud.ai.config.CodeExecutorProperties;
import com.alibaba.cloud.ai.service.code.CodePoolExecutorEnum;
import com.alibaba.cloud.ai.service.code.CodePoolExecutorService;
import com.alibaba.cloud.ai.service.code.impl.AiSimulationCodeExecutorService;
import com.alibaba.cloud.ai.service.code.impl.DockerCodePoolExecutorService;
import org.springframework.ai.chat.client.ChatClient;

public final class CodePoolExecutorServiceFactory {
    private CodePoolExecutorServiceFactory() {
    }

    public static CodePoolExecutorService newInstance(CodeExecutorProperties properties, ChatClient.Builder chatClientBuilder) {
        if (properties.getCodePoolExecutor().equals((Object)CodePoolExecutorEnum.DOCKER)) {
            return new DockerCodePoolExecutorService(properties);
        }
        if (properties.getCodePoolExecutor().equals((Object)CodePoolExecutorEnum.AI_SIMULATION)) {
            return new AiSimulationCodeExecutorService(chatClientBuilder);
        }
        throw new IllegalArgumentException("Unknown container impl: " + properties.getCodePoolExecutor());
    }
}

