/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.service.code.impl;

import com.alibaba.cloud.ai.config.CodeExecutorProperties;
import com.alibaba.cloud.ai.service.code.CodePoolExecutorService;
import com.alibaba.cloud.ai.service.code.impl.AbstractCodePoolExecutorService;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.command.PullImageResultCallback;
import com.github.dockerjava.api.model.AccessMode;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Capability;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.DockerClientImpl;
import com.github.dockerjava.transport.DockerHttpClient;
import com.github.dockerjava.transport.SSLConfig;
import com.github.dockerjava.zerodep.ZerodepDockerHttpClient;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class DockerCodePoolExecutorService
extends AbstractCodePoolExecutorService
implements CodePoolExecutorService {
    private static final Logger log = LoggerFactory.getLogger(DockerCodePoolExecutorService.class);
    private final DockerClient dockerClient;
    private final ConcurrentHashMap<String, Path> containerTempPath;

    public DockerCodePoolExecutorService(CodeExecutorProperties properties) {
        super(properties);
        String dockerHost = this.getDockerHostForCurrentOS(properties.getHost());
        DefaultDockerClientConfig config = DefaultDockerClientConfig.createDefaultConfigBuilder().withDockerHost(dockerHost).withDockerTlsVerify(Boolean.valueOf(false)).build();
        this.dockerClient = this.createDockerClientWithFallback((DockerClientConfig)config);
        this.containerTempPath = new ConcurrentHashMap();
        boolean imageExists = ((List)this.dockerClient.listImagesCmd().withImageNameFilter(properties.getImageName()).exec()).stream().anyMatch(image -> Arrays.asList(image.getRepoTags()).contains(properties.getImageName()));
        if (!imageExists) {
            try {
                ((PullImageResultCallback)this.dockerClient.pullImageCmd(properties.getImageName()).exec((ResultCallback)new PullImageResultCallback())).awaitCompletion();
                log.info("pull image {} success", (Object)properties.getImageName());
            }
            catch (Exception e) {
                log.error("pull image {} error", (Object)properties.getImageName(), (Object)e);
                throw new RuntimeException(e);
            }
        }
    }

    private String getDockerHostForCurrentOS(String dockerHost) {
        if (StringUtils.hasText((String)dockerHost)) {
            return dockerHost;
        }
        String osName = System.getProperty("os.name").toLowerCase();
        log.info("Detected operating system: {}", (Object)osName);
        if (osName.contains("win")) {
            log.info("Using Windows Docker configuration");
            return "tcp://localhost:2375";
        }
        if (osName.contains("nix") || osName.contains("nux") || osName.contains("aix")) {
            log.info("Using Linux/Unix Docker configuration");
            return "unix:///var/run/docker.sock";
        }
        if (osName.contains("mac")) {
            log.info("Using macOS Docker configuration");
            return "unix:///var/run/docker.sock";
        }
        log.warn("Unknown operating system: {}, using default docker host", (Object)osName);
        return "unix:///var/run/docker.sock";
    }

    private DockerClient createDockerClientWithFallback(DockerClientConfig config) {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            String[] windowsHosts;
            for (String dockerHost : windowsHosts = new String[]{"tcp://localhost:2375", "npipe://./pipe/docker_engine"}) {
                try {
                    log.info("Attempting to connect to Docker using: {}", (Object)dockerHost);
                    DefaultDockerClientConfig testConfig = DefaultDockerClientConfig.createDefaultConfigBuilder().withDockerHost(dockerHost).withDockerTlsVerify(Boolean.valueOf(false)).build();
                    ZerodepDockerHttpClient httpClient = new ZerodepDockerHttpClient.Builder().dockerHost(testConfig.getDockerHost()).sslConfig((SSLConfig)testConfig.getSSLConfig()).build();
                    DockerClient dockerClient = DockerClientImpl.getInstance((DockerClientConfig)testConfig, (DockerHttpClient)httpClient);
                    dockerClient.pingCmd().exec();
                    log.info("Successfully connected to Docker using: {}", (Object)dockerHost);
                    return dockerClient;
                }
                catch (Exception e) {
                    log.warn("Failed to connect using {}: {}", (Object)dockerHost, (Object)e.getMessage());
                }
            }
            throw new RuntimeException("Failed to connect to Docker on Windows. Please ensure Docker Desktop is running and either:\n1. Enable 'Expose daemon on tcp://localhost:2375 without TLS' in Docker Desktop settings, or\n2. Ensure Docker Desktop's named pipe is available");
        }
        try {
            ZerodepDockerHttpClient httpClient = new ZerodepDockerHttpClient.Builder().dockerHost(config.getDockerHost()).sslConfig((SSLConfig)config.getSSLConfig()).build();
            DockerClient dockerClient = DockerClientImpl.getInstance((DockerClientConfig)config, (DockerHttpClient)httpClient);
            dockerClient.pingCmd().exec();
            log.info("Successfully connected to Docker using: {}", (Object)config.getDockerHost());
            return dockerClient;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to connect to Docker on " + osName + ": " + e.getMessage() + "\nPlease ensure Docker is running and accessible at: " + config.getDockerHost());
        }
    }

    private HostConfig createHostConfig(Path tempDir) {
        ArrayList<Bind> binds = new ArrayList<Bind>();
        binds.add(new Bind(tempDir.resolve("script.py").toAbsolutePath().toString(), new Volume("/app/script.py"), AccessMode.ro));
        binds.add(new Bind(tempDir.resolve("requirements.txt").toAbsolutePath().toString(), new Volume("/app/requirements.txt"), AccessMode.ro));
        binds.add(new Bind(tempDir.resolve("input_data.txt").toAbsolutePath().toString(), new Volume("/app/input_data.txt"), AccessMode.ro));
        binds.add(new Bind(tempDir.resolve("stdout.txt").toAbsolutePath().toString(), new Volume("/app/stdout.txt"), AccessMode.rw));
        binds.add(new Bind(tempDir.resolve("stderr.txt").toAbsolutePath().toString(), new Volume("/app/stderr.txt"), AccessMode.rw));
        return HostConfig.newHostConfig().withMemory(Long.valueOf(this.properties.getLimitMemory() * 1024L * 1024L)).withCpuCount(this.properties.getCpuCore()).withCapDrop(new Capability[]{Capability.ALL}).withAutoRemove(Boolean.valueOf(false)).withBinds(binds.toArray(new Bind[0])).withTmpFs(Map.of("/tmp", "")).withNetworkMode(this.properties.getNetworkMode());
    }

    private void cleanupExistingResources(String containName) {
        try {
            this.dockerClient.removeContainerCmd(containName).withForce(Boolean.valueOf(true)).exec();
            log.info("Removed existing container: {}", (Object)containName);
        }
        catch (Exception e) {
            log.warn("Failed to remove container {}: {}", (Object)containName, (Object)e.getMessage());
        }
    }

    @Override
    protected String createNewContainer() throws Exception {
        String containerName = this.generateContainerName();
        this.cleanupExistingResources(containerName);
        Path tempDir = Files.createTempDirectory(containerName, new FileAttribute[0]);
        Files.createFile(tempDir.resolve("requirements.txt"), new FileAttribute[0]);
        Files.createFile(tempDir.resolve("script.py"), new FileAttribute[0]);
        Files.createFile(tempDir.resolve("input_data.txt"), new FileAttribute[0]);
        this.createWritableFile(tempDir, "stdout.txt");
        this.createWritableFile(tempDir, "stderr.txt");
        HostConfig hostConfig = this.createHostConfig(tempDir);
        CreateContainerResponse container = this.dockerClient.createContainerCmd(this.properties.getImageName()).withName(containerName).withWorkingDir("/app").withHostConfig(hostConfig).withCmd(new String[]{"sh", "-c", String.format("if [ -s requirements.txt ]; then pip3 install --no-cache-dir -r requirements.txt > /dev/null 2> stderr.txt; fi && { timeout -s SIGKILL %s python3 -u script.py < input_data.txt; } > stdout.txt 2>> stderr.txt", this.properties.getCodeTimeout())}).exec();
        String containerId = container.getId();
        this.containerTempPath.put(containerId, tempDir);
        return containerId;
    }

    @Override
    protected CodePoolExecutorService.TaskResponse execTaskInContainer(CodePoolExecutorService.TaskRequest request, String containerId) throws Exception {
        Path tempDir = this.containerTempPath.get(containerId);
        if (tempDir == null) {
            log.error("Container '{}' does not exist work dir", (Object)containerId);
            return CodePoolExecutorService.TaskResponse.error("Container '" + containerId + "' does not exist work dir");
        }
        Files.write(tempDir.resolve("script.py"), StringUtils.hasText((String)request.code()) ? request.code().getBytes() : "".getBytes(), new OpenOption[0]);
        Files.write(tempDir.resolve("requirements.txt"), StringUtils.hasText((String)request.requirement()) ? request.requirement().getBytes() : "".getBytes(), new OpenOption[0]);
        Files.write(tempDir.resolve("input_data.txt"), StringUtils.hasText((String)request.input()) ? request.input().getBytes() : "".getBytes(), new OpenOption[0]);
        Files.write(tempDir.resolve("stdout.txt"), "".getBytes(), new OpenOption[0]);
        Files.write(tempDir.resolve("stderr.txt"), "".getBytes(), new OpenOption[0]);
        try {
            this.dockerClient.startContainerCmd(containerId).exec();
            this.dockerClient.waitContainerCmd(containerId).start().awaitCompletion(this.properties.getContainerTimeout().longValue(), TimeUnit.SECONDS);
            String stdout = Files.readString(tempDir.resolve("stdout.txt"));
            String stderr = Files.readString(tempDir.resolve("stderr.txt"));
            InspectContainerResponse inspectResponse = this.dockerClient.inspectContainerCmd(containerId).exec();
            int exitCode = Objects.requireNonNull(inspectResponse.getState().getExitCodeLong()).intValue();
            if (exitCode != 0) {
                String errorMessage = "Docker exit code " + exitCode + ". Stderr: " + stderr + ". Stdout: " + stdout;
                log.error("Error executing Docker container {}: {}", (Object)containerId, (Object)errorMessage);
                return CodePoolExecutorService.TaskResponse.error(errorMessage);
            }
            return new CodePoolExecutorService.TaskResponse(true, stdout, stderr, null);
        }
        catch (Exception e) {
            log.error("Error when creating container in docker: {}", (Object)e.getMessage());
            return CodePoolExecutorService.TaskResponse.error(e.getMessage());
        }
    }

    @Override
    protected void stopContainer(String containerId) throws Exception {
        try {
            this.dockerClient.stopContainerCmd(containerId).exec();
            log.info("Successfully stopped container: {}", (Object)containerId);
        }
        catch (Exception e) {
            log.warn("Failed to stop container: {}, message: {}", (Object)containerId, (Object)e.getMessage());
        }
    }

    @Override
    protected void removeContainer(String containerId) throws Exception {
        try {
            this.dockerClient.removeContainerCmd(containerId).withForce(Boolean.valueOf(true)).exec();
            Path tempDir = this.containerTempPath.get(containerId);
            if (tempDir != null) {
                this.clearTempDir(tempDir);
            }
            this.containerTempPath.remove(containerId);
            log.info("Successfully removed container: {}", (Object)containerId);
        }
        catch (Exception e) {
            log.warn("Failed to remove container: {}, message: {}", (Object)containerId, (Object)e.getMessage());
        }
    }

    @Override
    protected void shutdownPool() throws Exception {
        try {
            super.shutdownPool();
            this.dockerClient.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

