/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.controller;

import com.alibaba.cloud.ai.entity.AgentKnowledge;
import com.alibaba.cloud.ai.service.AgentKnowledgeService;
import com.alibaba.cloud.ai.service.AgentVectorService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/agent-knowledge"})
@CrossOrigin(origins={"*"})
public class AgentKnowledgeController {
    private final AgentKnowledgeService agentKnowledgeService;
    private final AgentVectorService agentVectorService;

    public AgentKnowledgeController(AgentKnowledgeService agentKnowledgeService, AgentVectorService agentVectorService) {
        this.agentKnowledgeService = agentKnowledgeService;
        this.agentVectorService = agentVectorService;
    }

    @GetMapping(value={"/agent/{agentId}"})
    public ResponseEntity<Map<String, Object>> getKnowledgeByAgentId(@PathVariable Integer agentId, @RequestParam(required=false) String type, @RequestParam(required=false) String status, @RequestParam(required=false) String keyword) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            List<AgentKnowledge> knowledgeList = keyword != null && !keyword.trim().isEmpty() ? this.agentKnowledgeService.searchKnowledge(agentId, keyword.trim()) : (type != null && !type.trim().isEmpty() ? this.agentKnowledgeService.getKnowledgeByType(agentId, type) : (status != null && !status.trim().isEmpty() ? this.agentKnowledgeService.getKnowledgeByStatus(agentId, status) : this.agentKnowledgeService.getKnowledgeByAgentId(agentId)));
            response.put("success", true);
            response.put("data", knowledgeList);
            response.put("total", knowledgeList.size());
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            response.put("success", false);
            response.put("message", "\u67e5\u8be2\u77e5\u8bc6\u5217\u8868\u5931\u8d25\uff1a" + e.getMessage());
            return ResponseEntity.badRequest().body(response);
        }
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Map<String, Object>> getKnowledgeById(@PathVariable Integer id) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            AgentKnowledge knowledge = this.agentKnowledgeService.getKnowledgeById(id);
            if (knowledge != null) {
                response.put("success", true);
                response.put("data", knowledge);
                return ResponseEntity.ok(response);
            }
            response.put("success", false);
            response.put("message", "\u77e5\u8bc6\u4e0d\u5b58\u5728");
            return ResponseEntity.notFound().build();
        }
        catch (Exception e) {
            response.put("success", false);
            response.put("message", "\u67e5\u8be2\u77e5\u8bc6\u8be6\u60c5\u5931\u8d25\uff1a" + e.getMessage());
            return ResponseEntity.badRequest().body(response);
        }
    }

    @PostMapping
    public ResponseEntity<Map<String, Object>> createKnowledge(@RequestBody AgentKnowledge knowledge) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            if (knowledge.getAgentId() == null) {
                response.put("success", false);
                response.put("message", "\u667a\u80fd\u4f53ID\u4e0d\u80fd\u4e3a\u7a7a");
                return ResponseEntity.badRequest().body(response);
            }
            if (knowledge.getTitle() == null || knowledge.getTitle().trim().isEmpty()) {
                response.put("success", false);
                response.put("message", "\u77e5\u8bc6\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a");
                return ResponseEntity.badRequest().body(response);
            }
            AgentKnowledge createdKnowledge = this.agentKnowledgeService.createKnowledge(knowledge);
            if (createdKnowledge.getContent() != null && !createdKnowledge.getContent().trim().isEmpty() && "active".equals(createdKnowledge.getStatus())) {
                try {
                    this.agentVectorService.addKnowledgeToVector((long)createdKnowledge.getAgentId(), createdKnowledge);
                    createdKnowledge.setEmbeddingStatus("completed");
                    this.agentKnowledgeService.updateKnowledge(createdKnowledge.getId(), createdKnowledge);
                }
                catch (Exception vectorException) {
                    createdKnowledge.setEmbeddingStatus("failed");
                    this.agentKnowledgeService.updateKnowledge(createdKnowledge.getId(), createdKnowledge);
                    response.put("vectorWarning", "\u77e5\u8bc6\u5df2\u4fdd\u5b58\uff0c\u4f46\u5411\u91cf\u5316\u5931\u8d25\uff1a" + vectorException.getMessage());
                }
            }
            response.put("success", true);
            response.put("data", createdKnowledge);
            response.put("message", "\u77e5\u8bc6\u521b\u5efa\u6210\u529f");
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            response.put("success", false);
            response.put("message", "\u521b\u5efa\u77e5\u8bc6\u5931\u8d25\uff1a" + e.getMessage());
            return ResponseEntity.badRequest().body(response);
        }
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Map<String, Object>> updateKnowledge(@PathVariable Integer id, @RequestBody AgentKnowledge knowledge) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            if (knowledge.getTitle() == null || knowledge.getTitle().trim().isEmpty()) {
                response.put("success", false);
                response.put("message", "\u77e5\u8bc6\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a");
                return ResponseEntity.badRequest().body(response);
            }
            AgentKnowledge originalKnowledge = this.agentKnowledgeService.getKnowledgeById(id);
            if (originalKnowledge == null) {
                response.put("success", false);
                response.put("message", "\u77e5\u8bc6\u4e0d\u5b58\u5728");
                return ResponseEntity.notFound().build();
            }
            AgentKnowledge updatedKnowledge = this.agentKnowledgeService.updateKnowledge(id, knowledge);
            if (updatedKnowledge != null) {
                try {
                    boolean statusChangedFromActive;
                    Long agentId = (long)updatedKnowledge.getAgentId();
                    boolean contentChanged = !Objects.equals(originalKnowledge.getContent(), updatedKnowledge.getContent());
                    boolean statusChangedToActive = !"active".equals(originalKnowledge.getStatus()) && "active".equals(updatedKnowledge.getStatus());
                    boolean bl = statusChangedFromActive = "active".equals(originalKnowledge.getStatus()) && !"active".equals(updatedKnowledge.getStatus());
                    if (statusChangedFromActive) {
                        this.agentVectorService.deleteKnowledgeFromVector(agentId, id);
                        updatedKnowledge.setEmbeddingStatus("pending");
                    } else if ((contentChanged || statusChangedToActive) && "active".equals(updatedKnowledge.getStatus()) && updatedKnowledge.getContent() != null && !updatedKnowledge.getContent().trim().isEmpty()) {
                        this.agentVectorService.deleteKnowledgeFromVector(agentId, id);
                        this.agentVectorService.addKnowledgeToVector(agentId, updatedKnowledge);
                        updatedKnowledge.setEmbeddingStatus("completed");
                        this.agentKnowledgeService.updateKnowledge(id, updatedKnowledge);
                    }
                }
                catch (Exception vectorException) {
                    updatedKnowledge.setEmbeddingStatus("failed");
                    this.agentKnowledgeService.updateKnowledge(id, updatedKnowledge);
                    response.put("vectorWarning", "\u77e5\u8bc6\u5df2\u66f4\u65b0\uff0c\u4f46\u5411\u91cf\u5316\u5931\u8d25\uff1a" + vectorException.getMessage());
                }
                response.put("success", true);
                response.put("data", updatedKnowledge);
                response.put("message", "\u77e5\u8bc6\u66f4\u65b0\u6210\u529f");
                return ResponseEntity.ok(response);
            }
            response.put("success", false);
            response.put("message", "\u77e5\u8bc6\u66f4\u65b0\u5931\u8d25");
            return ResponseEntity.badRequest().body(response);
        }
        catch (Exception e) {
            response.put("success", false);
            response.put("message", "\u66f4\u65b0\u77e5\u8bc6\u5931\u8d25\uff1a" + e.getMessage());
            return ResponseEntity.badRequest().body(response);
        }
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Map<String, Object>> deleteKnowledge(@PathVariable Integer id) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            AgentKnowledge knowledge = this.agentKnowledgeService.getKnowledgeById(id);
            if (knowledge == null) {
                response.put("success", false);
                response.put("message", "\u77e5\u8bc6\u4e0d\u5b58\u5728");
                return ResponseEntity.notFound().build();
            }
            boolean deleted = this.agentKnowledgeService.deleteKnowledge(id);
            if (deleted) {
                try {
                    Long agentId = (long)knowledge.getAgentId();
                    this.agentVectorService.deleteKnowledgeFromVector(agentId, id);
                }
                catch (Exception vectorException) {
                    response.put("vectorWarning", "\u77e5\u8bc6\u5df2\u5220\u9664\uff0c\u4f46\u5411\u91cf\u6570\u636e\u5220\u9664\u5931\u8d25\uff1a" + vectorException.getMessage());
                }
                response.put("success", true);
                response.put("message", "\u77e5\u8bc6\u5220\u9664\u6210\u529f");
                return ResponseEntity.ok(response);
            }
            response.put("success", false);
            response.put("message", "\u77e5\u8bc6\u5220\u9664\u5931\u8d25");
            return ResponseEntity.badRequest().body(response);
        }
        catch (Exception e) {
            response.put("success", false);
            response.put("message", "\u5220\u9664\u77e5\u8bc6\u5931\u8d25\uff1a" + e.getMessage());
            return ResponseEntity.badRequest().body(response);
        }
    }

    @PutMapping(value={"/batch/status"})
    public ResponseEntity<Map<String, Object>> batchUpdateStatus(@RequestBody Map<String, Object> request) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            List ids = (List)request.get("ids");
            String status = (String)request.get("status");
            if (ids == null || ids.isEmpty()) {
                response.put("success", false);
                response.put("message", "ID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
                return ResponseEntity.badRequest().body(response);
            }
            if (status == null || status.trim().isEmpty()) {
                response.put("success", false);
                response.put("message", "\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
                return ResponseEntity.badRequest().body(response);
            }
            int updatedCount = this.agentKnowledgeService.batchUpdateStatus(ids, status);
            response.put("success", true);
            response.put("message", "\u6279\u91cf\u66f4\u65b0\u6210\u529f\uff0c\u5171\u66f4\u65b0 " + updatedCount + " \u6761\u8bb0\u5f55");
            response.put("updatedCount", updatedCount);
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            response.put("success", false);
            response.put("message", "\u6279\u91cf\u66f4\u65b0\u5931\u8d25\uff1a" + e.getMessage());
            return ResponseEntity.badRequest().body(response);
        }
    }

    @GetMapping(value={"/statistics/{agentId}"})
    public ResponseEntity<Map<String, Object>> getKnowledgeStatistics(@PathVariable Integer agentId) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            int totalCount = this.agentKnowledgeService.countKnowledgeByAgent(agentId);
            List<Object[]> typeStatistics = this.agentKnowledgeService.countKnowledgeByType(agentId);
            HashMap<String, Object> statistics = new HashMap<String, Object>();
            statistics.put("totalCount", totalCount);
            statistics.put("typeStatistics", typeStatistics);
            response.put("success", true);
            response.put("data", statistics);
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            response.put("success", false);
            response.put("message", "\u83b7\u53d6\u7edf\u8ba1\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            return ResponseEntity.badRequest().body(response);
        }
    }
}

