/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.controller;

import com.alibaba.cloud.ai.controller.Nl2sqlForGraphController;
import com.alibaba.cloud.ai.service.AgentVectorService;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import reactor.core.publisher.Flux;

@Controller
@RequestMapping(value={"/api/agent/{agentId}/schema"})
@CrossOrigin(origins={"*"})
public class AgentSchemaController {
    private static final Logger log = LoggerFactory.getLogger(AgentSchemaController.class);
    private final AgentVectorService agentVectorService;
    private final Nl2sqlForGraphController nl2sqlForGraphController;

    public AgentSchemaController(AgentVectorService agentVectorService, Nl2sqlForGraphController nl2sqlForGraphController) {
        this.agentVectorService = agentVectorService;
        this.nl2sqlForGraphController = nl2sqlForGraphController;
    }

    @PostMapping(value={"/init"})
    @ResponseBody
    public ResponseEntity<Map<String, Object>> initializeSchema(@PathVariable Long agentId, @RequestBody Map<String, Object> requestData) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            Map dbConfig;
            log.info("Initializing schema for agent: {}", (Object)agentId);
            Integer datasourceId = null;
            List tables = null;
            if (requestData.containsKey("datasourceId")) {
                datasourceId = (Integer)requestData.get("datasourceId");
            } else if (requestData.containsKey("dbConfig") && (dbConfig = (Map)requestData.get("dbConfig")).containsKey("id")) {
                datasourceId = (Integer)dbConfig.get("id");
            }
            if (requestData.containsKey("tables")) {
                tables = (List)requestData.get("tables");
            }
            if (datasourceId == null) {
                response.put("success", false);
                response.put("message", "\u6570\u636e\u6e90ID\u4e0d\u80fd\u4e3a\u7a7a");
                return ResponseEntity.badRequest().body(response);
            }
            if (tables == null || tables.isEmpty()) {
                response.put("success", false);
                response.put("message", "\u8868\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
                return ResponseEntity.badRequest().body(response);
            }
            Boolean result = this.agentVectorService.initializeSchemaForAgentWithDatasource(agentId, datasourceId, tables);
            if (result.booleanValue()) {
                response.put("success", true);
                response.put("message", "Schema\u521d\u59cb\u5316\u6210\u529f");
                response.put("agentId", agentId);
                response.put("tablesCount", tables.size());
                log.info("Successfully initialized schema for agent: {}, tables: {}", (Object)agentId, (Object)tables.size());
                return ResponseEntity.ok(response);
            }
            response.put("success", false);
            response.put("message", "Schema\u521d\u59cb\u5316\u5931\u8d25");
            return ResponseEntity.badRequest().body(response);
        }
        catch (Exception e) {
            log.error("Failed to initialize schema for agent: {}", (Object)agentId, (Object)e);
            response.put("success", false);
            response.put("message", "Schema\u521d\u59cb\u5316\u5931\u8d25\uff1a" + e.getMessage());
            return ResponseEntity.badRequest().body(response);
        }
    }

    @GetMapping(value={"/statistics"})
    @ResponseBody
    public ResponseEntity<Map<String, Object>> getVectorStatistics(@PathVariable Long agentId) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            Map<String, Object> statistics = this.agentVectorService.getVectorStatistics(agentId);
            response.put("success", true);
            response.put("data", statistics);
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            log.error("Failed to get vector statistics for agent: {}", (Object)agentId, (Object)e);
            response.put("success", false);
            response.put("message", "\u83b7\u53d6\u7edf\u8ba1\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            return ResponseEntity.badRequest().body(response);
        }
    }

    @DeleteMapping(value={"/clear"})
    @ResponseBody
    public ResponseEntity<Map<String, Object>> clearVectorData(@PathVariable Long agentId) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            log.info("Clearing all vector data for agent: {}", (Object)agentId);
            this.agentVectorService.deleteAllVectorDataForAgent(agentId);
            response.put("success", true);
            response.put("message", "\u5411\u91cf\u6570\u636e\u6e05\u7a7a\u6210\u529f");
            response.put("agentId", agentId);
            log.info("Successfully cleared all vector data for agent: {}", (Object)agentId);
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            log.error("Failed to clear vector data for agent: {}", (Object)agentId, (Object)e);
            response.put("success", false);
            response.put("message", "\u6e05\u7a7a\u5411\u91cf\u6570\u636e\u5931\u8d25\uff1a" + e.getMessage());
            return ResponseEntity.badRequest().body(response);
        }
    }

    @GetMapping(value={"/datasources"})
    @ResponseBody
    public ResponseEntity<Map<String, Object>> getAgentDatasources(@PathVariable Long agentId) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            log.info("Getting datasources for agent: {}", (Object)agentId);
            List<Map<String, Object>> datasources = this.agentVectorService.getAgentDatasources(agentId);
            response.put("success", true);
            response.put("data", datasources);
            response.put("agentId", agentId);
            log.info("Successfully retrieved {} datasources for agent: {}", (Object)datasources.size(), (Object)agentId);
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            log.error("Failed to get datasources for agent: {}", (Object)agentId, (Object)e);
            response.put("success", false);
            response.put("message", "\u83b7\u53d6\u6570\u636e\u6e90\u5931\u8d25\uff1a" + e.getMessage());
            response.put("data", new ArrayList());
            return ResponseEntity.badRequest().body(response);
        }
    }

    @GetMapping(value={"/datasources/{datasourceId}/tables"})
    @ResponseBody
    public ResponseEntity<Map<String, Object>> getDatasourceTables(@PathVariable Integer datasourceId) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            log.info("Getting tables for datasource: {}", (Object)datasourceId);
            List<String> tables = this.agentVectorService.getDatasourceTables(datasourceId);
            response.put("success", true);
            response.put("data", tables);
            response.put("datasourceId", datasourceId);
            log.info("Successfully retrieved {} tables for datasource: {}", (Object)tables.size(), (Object)datasourceId);
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            log.error("Failed to get tables for datasource: {}", (Object)datasourceId, (Object)e);
            response.put("success", false);
            response.put("message", "\u83b7\u53d6\u8868\u5217\u8868\u5931\u8d25\uff1a" + e.getMessage());
            response.put("data", new ArrayList());
            return ResponseEntity.badRequest().body(response);
        }
    }

    @PostMapping(value={"/chat"}, produces={"text/event-stream"})
    @ResponseBody
    public Flux<ServerSentEvent<String>> agentChat(@PathVariable Long agentId, @RequestBody Map<String, Object> requestData, HttpServletResponse response) {
        try {
            String query = (String)requestData.get("query");
            if (query == null || query.trim().isEmpty()) {
                return Flux.just((Object)ServerSentEvent.builder((Object)"{\"success\": false, \"message\": \"\u67e5\u8be2\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\"}").event("error").build());
            }
            log.info("Agent {} chat request: {}", (Object)agentId, (Object)query);
            return this.nl2sqlForGraphController.streamSearch(query.trim(), String.valueOf(agentId), response);
        }
        catch (Exception e) {
            log.error("Failed to process chat request for agent: {}", (Object)agentId, (Object)e);
            return Flux.just((Object)ServerSentEvent.builder((Object)("{\"success\": false, \"message\": \"\u804a\u5929\u5904\u7406\u5931\u8d25\uff1a" + e.getMessage() + "\"}")).event("error").build());
        }
    }
}

