/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.controller;

import com.alibaba.cloud.ai.entity.BusinessKnowledge;
import com.alibaba.cloud.ai.service.BusinessKnowledgeService;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/business-knowledge"})
@CrossOrigin(origins={"*"})
public class BusinessKnowledgeController {
    private final BusinessKnowledgeService businessKnowledgeService;

    public BusinessKnowledgeController(BusinessKnowledgeService businessKnowledgeService) {
        this.businessKnowledgeService = businessKnowledgeService;
    }

    @GetMapping
    @ResponseBody
    public ResponseEntity<List<BusinessKnowledge>> list(@RequestParam(required=false) String datasetId, @RequestParam(required=false) String keyword) {
        List<BusinessKnowledge> result = keyword != null && !keyword.trim().isEmpty() ? this.businessKnowledgeService.search(keyword) : (datasetId != null && !datasetId.trim().isEmpty() ? this.businessKnowledgeService.findByDatasetId(datasetId) : this.businessKnowledgeService.findAll());
        return ResponseEntity.ok(result);
    }

    @GetMapping(value={"/{id}"})
    @ResponseBody
    public ResponseEntity<BusinessKnowledge> get(@PathVariable Long id) {
        BusinessKnowledge knowledge = this.businessKnowledgeService.findById(id);
        if (knowledge == null) {
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.ok((Object)knowledge);
    }

    @PostMapping
    @ResponseBody
    public ResponseEntity<BusinessKnowledge> create(@RequestBody BusinessKnowledge knowledge) {
        BusinessKnowledge saved = this.businessKnowledgeService.save(knowledge);
        return ResponseEntity.ok((Object)saved);
    }

    @PutMapping(value={"/{id}"})
    @ResponseBody
    public ResponseEntity<BusinessKnowledge> update(@PathVariable Long id, @RequestBody BusinessKnowledge knowledge) {
        if (this.businessKnowledgeService.findById(id) == null) {
            return ResponseEntity.notFound().build();
        }
        knowledge.setId(id);
        BusinessKnowledge updated = this.businessKnowledgeService.save(knowledge);
        return ResponseEntity.ok((Object)updated);
    }

    @DeleteMapping(value={"/{id}"})
    @ResponseBody
    public ResponseEntity<Void> delete(@PathVariable Long id) {
        if (this.businessKnowledgeService.findById(id) == null) {
            return ResponseEntity.notFound().build();
        }
        this.businessKnowledgeService.deleteById(id);
        return ResponseEntity.ok().build();
    }
}

