/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.service;

import com.alibaba.cloud.ai.entity.AgentPresetQuestion;
import java.sql.PreparedStatement;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Service;

@Service
public class AgentPresetQuestionService {
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private static final String SELECT_BY_AGENT_ID = "SELECT * FROM agent_preset_question\nWHERE agent_id = ? AND is_active = 1\nORDER BY sort_order ASC, id ASC\n";
    private static final String INSERT = "INSERT INTO agent_preset_question (agent_id, question, sort_order, is_active, create_time, update_time)\nVALUES (?, ?, ?, ?, NOW(), NOW())\n";
    private static final String UPDATE = "UPDATE agent_preset_question\nSET question = ?, sort_order = ?, is_active = ?, update_time = NOW()\nWHERE id = ?\n";
    private static final String DELETE = "DELETE FROM agent_preset_question WHERE id = ?\n";
    private static final String DELETE_BY_AGENT_ID = "DELETE FROM agent_preset_question WHERE agent_id = ?\n";

    public List<AgentPresetQuestion> findByAgentId(Long agentId) {
        return this.jdbcTemplate.query(SELECT_BY_AGENT_ID, (RowMapper)new BeanPropertyRowMapper(AgentPresetQuestion.class), new Object[]{agentId});
    }

    public AgentPresetQuestion create(AgentPresetQuestion question) {
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        this.jdbcTemplate.update(connection -> {
            PreparedStatement ps = connection.prepareStatement(INSERT, 1);
            ps.setLong(1, question.getAgentId());
            ps.setString(2, question.getQuestion());
            ps.setInt(3, question.getSortOrder() != null ? question.getSortOrder() : 0);
            ps.setBoolean(4, question.getIsActive() != null ? question.getIsActive() : true);
            return ps;
        }, (KeyHolder)keyHolder);
        question.setId(keyHolder.getKey().longValue());
        return question;
    }

    public void update(Long id, AgentPresetQuestion question) {
        this.jdbcTemplate.update(UPDATE, new Object[]{question.getQuestion(), question.getSortOrder(), question.getIsActive(), id});
    }

    public void deleteById(Long id) {
        this.jdbcTemplate.update(DELETE, new Object[]{id});
    }

    public void deleteByAgentId(Long agentId) {
        this.jdbcTemplate.update(DELETE_BY_AGENT_ID, new Object[]{agentId});
    }

    public void batchSave(Long agentId, List<AgentPresetQuestion> questions) {
        this.deleteByAgentId(agentId);
        for (int i = 0; i < questions.size(); ++i) {
            AgentPresetQuestion question = questions.get(i);
            question.setAgentId(agentId);
            question.setSortOrder(i);
            question.setIsActive(true);
            this.create(question);
        }
    }
}

