/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.service;

import com.alibaba.cloud.ai.entity.Agent;
import com.alibaba.cloud.ai.service.AgentVectorService;
import java.sql.PreparedStatement;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Service;

@Service
public class AgentService {
    private static final Logger log = LoggerFactory.getLogger(AgentService.class);
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired(required=false)
    private AgentVectorService agentVectorService;
    private static final String SELECT_ALL = "SELECT * FROM agent ORDER BY create_time DESC\n";
    private static final String SELECT_BY_ID = "SELECT * FROM agent WHERE id = ?\n";
    private static final String SELECT_BY_STATUS = "SELECT * FROM agent WHERE status = ? ORDER BY create_time DESC\n";
    private static final String SEARCH_BY_KEYWORD = "SELECT * FROM agent\nWHERE (name LIKE ? OR description LIKE ? OR tags LIKE ?)\nORDER BY create_time DESC\n";
    private static final String INSERT = "INSERT INTO agent (name, description, avatar, status, prompt, category, admin_id, tags, create_time, update_time)\nVALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\n";
    private static final String UPDATE = "UPDATE agent SET name = ?, description = ?, avatar = ?, status = ?, prompt = ?,\ncategory = ?, admin_id = ?, tags = ?, update_time = ? WHERE id = ?\n";
    private static final String DELETE = "DELETE FROM agent WHERE id = ?\n";

    public List<Agent> findAll() {
        return this.jdbcTemplate.query(SELECT_ALL, (RowMapper)new BeanPropertyRowMapper(Agent.class));
    }

    public Agent findById(Long id) {
        List results = this.jdbcTemplate.query(SELECT_BY_ID, (RowMapper)new BeanPropertyRowMapper(Agent.class), new Object[]{id});
        return results.isEmpty() ? null : (Agent)results.get(0);
    }

    public List<Agent> findByStatus(String status) {
        return this.jdbcTemplate.query(SELECT_BY_STATUS, (RowMapper)new BeanPropertyRowMapper(Agent.class), new Object[]{status});
    }

    public List<Agent> search(String keyword) {
        String searchPattern = "%" + keyword + "%";
        return this.jdbcTemplate.query(SEARCH_BY_KEYWORD, (RowMapper)new BeanPropertyRowMapper(Agent.class), new Object[]{searchPattern, searchPattern, searchPattern});
    }

    public Agent save(Agent agent) {
        LocalDateTime now = LocalDateTime.now();
        if (agent.getId() == null) {
            agent.setCreateTime(now);
            agent.setUpdateTime(now);
            GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
            this.jdbcTemplate.update(connection -> {
                PreparedStatement ps = connection.prepareStatement(INSERT, 1);
                ps.setString(1, agent.getName());
                ps.setString(2, agent.getDescription());
                ps.setString(3, agent.getAvatar());
                ps.setString(4, agent.getStatus());
                ps.setString(5, agent.getPrompt());
                ps.setString(6, agent.getCategory());
                ps.setObject(7, agent.getAdminId());
                ps.setString(8, agent.getTags());
                ps.setObject(9, agent.getCreateTime());
                ps.setObject(10, agent.getUpdateTime());
                return ps;
            }, (KeyHolder)keyHolder);
            Number key = keyHolder.getKey();
            if (key != null) {
                agent.setId(key.longValue());
            }
        } else {
            agent.setUpdateTime(now);
            this.jdbcTemplate.update(UPDATE, new Object[]{agent.getName(), agent.getDescription(), agent.getAvatar(), agent.getStatus(), agent.getPrompt(), agent.getCategory(), agent.getAdminId(), agent.getTags(), agent.getUpdateTime(), agent.getId()});
        }
        return agent;
    }

    public void deleteById(Long id) {
        try {
            this.jdbcTemplate.update(DELETE, new Object[]{id});
            if (this.agentVectorService != null) {
                try {
                    this.agentVectorService.deleteAllVectorDataForAgent(id);
                    log.info("Successfully deleted vector data for agent: {}", (Object)id);
                }
                catch (Exception vectorException) {
                    log.warn("Failed to delete vector data for agent: {}, error: {}", (Object)id, (Object)vectorException.getMessage());
                }
            }
            log.info("Successfully deleted agent: {}", (Object)id);
        }
        catch (Exception e) {
            log.error("Failed to delete agent: {}", (Object)id, (Object)e);
            throw e;
        }
    }
}

