/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.service;

import com.alibaba.cloud.ai.connector.accessor.Accessor;
import com.alibaba.cloud.ai.connector.bo.DbQueryParameter;
import com.alibaba.cloud.ai.connector.bo.TableInfoBO;
import com.alibaba.cloud.ai.connector.config.DbConfig;
import com.alibaba.cloud.ai.entity.AgentDatasource;
import com.alibaba.cloud.ai.entity.AgentKnowledge;
import com.alibaba.cloud.ai.entity.Datasource;
import com.alibaba.cloud.ai.request.SchemaInitRequest;
import com.alibaba.cloud.ai.service.DatasourceService;
import com.alibaba.cloud.ai.service.simple.SimpleVectorStoreService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.document.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class AgentVectorService {
    private static final Logger log = LoggerFactory.getLogger(AgentVectorService.class);
    @Autowired
    private SimpleVectorStoreService vectorStoreService;
    @Autowired
    private DatasourceService datasourceService;
    @Autowired
    @Qualifier(value="mysqlAccessor")
    private Accessor dbAccessor;

    public Boolean initializeSchemaForAgent(Long agentId, SchemaInitRequest schemaInitRequest) {
        try {
            String agentIdStr = String.valueOf(agentId);
            log.info("Initializing schema for agent: {}", (Object)agentIdStr);
            return this.vectorStoreService.schemaForAgent(agentIdStr, schemaInitRequest);
        }
        catch (Exception e) {
            log.error("Failed to initialize schema for agent: {}", (Object)agentId, (Object)e);
            throw new RuntimeException("Failed to initialize schema for agent " + agentId + ": " + e.getMessage(), e);
        }
    }

    public void addKnowledgeToVector(Long agentId, AgentKnowledge knowledge) {
        try {
            String agentIdStr = String.valueOf(agentId);
            log.info("Adding knowledge to vector store for agent: {}, knowledge ID: {}", (Object)agentIdStr, (Object)knowledge.getId());
            Document document = this.createDocumentFromKnowledge(agentIdStr, knowledge);
            this.vectorStoreService.getAgentVectorStoreManager().addDocuments(agentIdStr, List.of(document));
            log.info("Successfully added knowledge to vector store for agent: {}", (Object)agentIdStr);
        }
        catch (Exception e) {
            log.error("Failed to add knowledge to vector store for agent: {}, knowledge ID: {}", new Object[]{agentId, knowledge.getId(), e});
            throw new RuntimeException("Failed to add knowledge to vector store: " + e.getMessage(), e);
        }
    }

    public void addKnowledgeListToVector(Long agentId, List<AgentKnowledge> knowledgeList) {
        if (knowledgeList == null || knowledgeList.isEmpty()) {
            log.warn("No knowledge to add for agent: {}", (Object)agentId);
            return;
        }
        try {
            String agentIdStr = String.valueOf(agentId);
            log.info("Adding {} knowledge items to vector store for agent: {}", (Object)knowledgeList.size(), (Object)agentIdStr);
            List<Document> documents = knowledgeList.stream().map(knowledge -> this.createDocumentFromKnowledge(agentIdStr, (AgentKnowledge)knowledge)).toList();
            this.vectorStoreService.getAgentVectorStoreManager().addDocuments(agentIdStr, documents);
            log.info("Successfully added {} knowledge items to vector store for agent: {}", (Object)documents.size(), (Object)agentIdStr);
        }
        catch (Exception e) {
            log.error("Failed to add knowledge list to vector store for agent: {}", (Object)agentId, (Object)e);
            throw new RuntimeException("Failed to add knowledge list to vector store: " + e.getMessage(), e);
        }
    }

    public List<Document> searchKnowledge(Long agentId, String query, int topK) {
        try {
            String agentIdStr = String.valueOf(agentId);
            log.debug("Searching knowledge for agent: {}, query: {}, topK: {}", new Object[]{agentIdStr, query, topK});
            List results = this.vectorStoreService.getAgentVectorStoreManager().similaritySearch(agentIdStr, query, topK);
            log.info("Found {} knowledge documents for agent: {}", (Object)results.size(), (Object)agentIdStr);
            return results;
        }
        catch (Exception e) {
            log.error("Failed to search knowledge for agent: {}", (Object)agentId, (Object)e);
            throw new RuntimeException("Failed to search knowledge: " + e.getMessage(), e);
        }
    }

    public List<Document> searchKnowledgeByType(Long agentId, String query, int topK, String knowledgeType) {
        try {
            String agentIdStr = String.valueOf(agentId);
            log.debug("Searching knowledge by type for agent: {}, query: {}, topK: {}, type: {}", new Object[]{agentIdStr, query, topK, knowledgeType});
            List results = this.vectorStoreService.getAgentVectorStoreManager().similaritySearchWithFilter(agentIdStr, query, topK, "knowledge:" + knowledgeType);
            log.info("Found {} knowledge documents of type '{}' for agent: {}", new Object[]{results.size(), knowledgeType, agentIdStr});
            return results;
        }
        catch (Exception e) {
            log.error("Failed to search knowledge by type for agent: {}", (Object)agentId, (Object)e);
            throw new RuntimeException("Failed to search knowledge by type: " + e.getMessage(), e);
        }
    }

    public void deleteKnowledgeFromVector(Long agentId, Integer knowledgeId) {
        try {
            String agentIdStr = String.valueOf(agentId);
            String documentId = agentIdStr + ":knowledge:" + knowledgeId;
            log.info("Deleting knowledge from vector store for agent: {}, knowledge ID: {}", (Object)agentIdStr, (Object)knowledgeId);
            this.vectorStoreService.getAgentVectorStoreManager().deleteDocuments(agentIdStr, List.of(documentId));
            log.info("Successfully deleted knowledge from vector store for agent: {}", (Object)agentIdStr);
        }
        catch (Exception e) {
            log.error("Failed to delete knowledge from vector store for agent: {}, knowledge ID: {}", new Object[]{agentId, knowledgeId, e});
            throw new RuntimeException("Failed to delete knowledge from vector store: " + e.getMessage(), e);
        }
    }

    public void deleteAllVectorDataForAgent(Long agentId) {
        try {
            String agentIdStr = String.valueOf(agentId);
            log.info("Deleting all vector data for agent: {}", (Object)agentIdStr);
            this.vectorStoreService.getAgentVectorStoreManager().deleteAgentData(agentIdStr);
            log.info("Successfully deleted all vector data for agent: {}", (Object)agentIdStr);
        }
        catch (Exception e) {
            log.error("Failed to delete all vector data for agent: {}", (Object)agentId, (Object)e);
            throw new RuntimeException("Failed to delete all vector data: " + e.getMessage(), e);
        }
    }

    public Map<String, Object> getVectorStatistics(Long agentId) {
        try {
            String agentIdStr = String.valueOf(agentId);
            HashMap<String, Object> stats = new HashMap<String, Object>();
            boolean hasData = this.vectorStoreService.getAgentVectorStoreManager().hasAgentData(agentIdStr);
            int documentCount = this.vectorStoreService.getAgentVectorStoreManager().getDocumentCount(agentIdStr);
            stats.put("agentId", agentId);
            stats.put("hasData", hasData);
            stats.put("documentCount", documentCount);
            log.debug("Vector statistics for agent {}: hasData={}, documentCount={}", new Object[]{agentIdStr, hasData, documentCount});
            return stats;
        }
        catch (Exception e) {
            log.error("Failed to get vector statistics for agent: {}", (Object)agentId, (Object)e);
            throw new RuntimeException("Failed to get vector statistics: " + e.getMessage(), e);
        }
    }

    private Document createDocumentFromKnowledge(String agentId, AgentKnowledge knowledge) {
        String documentId = agentId + ":knowledge:" + knowledge.getId();
        String content = knowledge.getContent();
        if (content == null || content.trim().isEmpty()) {
            content = knowledge.getTitle();
        }
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("agentId", agentId);
        metadata.put("knowledgeId", knowledge.getId());
        metadata.put("title", knowledge.getTitle());
        metadata.put("type", knowledge.getType());
        metadata.put("category", knowledge.getCategory());
        metadata.put("tags", knowledge.getTags());
        metadata.put("status", knowledge.getStatus());
        metadata.put("vectorType", "knowledge:" + knowledge.getType());
        metadata.put("sourceUrl", knowledge.getSourceUrl());
        metadata.put("fileType", knowledge.getFileType());
        metadata.put("embeddingStatus", knowledge.getEmbeddingStatus());
        metadata.put("createTime", knowledge.getCreateTime());
        return new Document(documentId, content, metadata);
    }

    public List<Map<String, Object>> getAgentDatasources(Long agentId) {
        try {
            log.info("Getting datasources for agent: {}", (Object)agentId);
            List agentDatasources = this.datasourceService.getAgentDatasources(Integer.valueOf(agentId.intValue()));
            ArrayList<Map<String, Object>> datasources = new ArrayList<Map<String, Object>>();
            for (AgentDatasource agentDatasource : agentDatasources) {
                Datasource datasource;
                if (agentDatasource.getIsActive() == null || (datasource = agentDatasource.getDatasource()) == null) continue;
                HashMap<String, Object> dsMap = new HashMap<String, Object>();
                dsMap.put("id", datasource.getId());
                dsMap.put("name", datasource.getName());
                dsMap.put("type", datasource.getType());
                dsMap.put("host", datasource.getHost());
                dsMap.put("port", datasource.getPort());
                dsMap.put("databaseName", datasource.getDatabaseName());
                dsMap.put("username", datasource.getUsername());
                dsMap.put("password", datasource.getPassword());
                dsMap.put("connectionUrl", datasource.getConnectionUrl());
                dsMap.put("status", datasource.getStatus());
                dsMap.put("testStatus", datasource.getTestStatus());
                dsMap.put("description", datasource.getDescription());
                dsMap.put("isActive", agentDatasource.getIsActive());
                dsMap.put("createTime", agentDatasource.getCreateTime());
                datasources.add(dsMap);
            }
            log.info("Found {} active datasources for agent: {}", (Object)datasources.size(), (Object)agentId);
            return datasources;
        }
        catch (Exception e) {
            log.error("Failed to get datasources for agent: {}", (Object)agentId, (Object)e);
            throw new RuntimeException("Failed to get datasources: " + e.getMessage(), e);
        }
    }

    public List<String> getDatasourceTables(Integer datasourceId) {
        try {
            log.info("Getting tables for datasource: {}", (Object)datasourceId);
            Datasource datasource = this.datasourceService.getDatasourceById(datasourceId);
            if (datasource == null) {
                throw new RuntimeException("Datasource not found with id: " + datasourceId);
            }
            if (!"mysql".equalsIgnoreCase(datasource.getType())) {
                log.warn("Unsupported datasource type: {}, only MySQL is supported currently", (Object)datasource.getType());
                return new ArrayList<String>();
            }
            DbConfig dbConfig = this.createDbConfigFromDatasource(datasource);
            DbQueryParameter queryParam = DbQueryParameter.from((DbConfig)dbConfig);
            queryParam.setSchema(datasource.getDatabaseName());
            List tableInfoList = this.dbAccessor.showTables(dbConfig, queryParam);
            List<String> tableNames = tableInfoList.stream().map(TableInfoBO::getName).filter(name -> name != null && !name.trim().isEmpty()).sorted().toList();
            log.info("Found {} tables for datasource: {}", (Object)tableNames.size(), (Object)datasourceId);
            return tableNames;
        }
        catch (Exception e) {
            log.error("Failed to get tables for datasource: {}", (Object)datasourceId, (Object)e);
            throw new RuntimeException("Failed to get tables: " + e.getMessage(), e);
        }
    }

    private DbConfig createDbConfigFromDatasource(Datasource datasource) {
        DbConfig dbConfig = new DbConfig();
        dbConfig.setUrl(datasource.getConnectionUrl());
        dbConfig.setUsername(datasource.getUsername());
        dbConfig.setPassword(datasource.getPassword());
        if ("mysql".equalsIgnoreCase(datasource.getType())) {
            dbConfig.setConnectionType("jdbc");
            dbConfig.setDialectType("mysql");
        }
        dbConfig.setSchema(datasource.getDatabaseName());
        log.debug("Created DbConfig for datasource {}: url={}, schema={}, type={}", new Object[]{datasource.getId(), dbConfig.getUrl(), dbConfig.getSchema(), dbConfig.getDialectType()});
        return dbConfig;
    }

    public Boolean initializeSchemaForAgentWithDatasource(Long agentId, Integer datasourceId, List<String> tables) {
        try {
            String agentIdStr = String.valueOf(agentId);
            log.info("Initializing schema for agent: {} with datasource: {}, tables: {}", new Object[]{agentIdStr, datasourceId, tables});
            Datasource datasource = this.datasourceService.getDatasourceById(datasourceId);
            if (datasource == null) {
                throw new RuntimeException("Datasource not found with id: " + datasourceId);
            }
            DbConfig dbConfig = this.createDbConfigFromDatasource(datasource);
            SchemaInitRequest schemaInitRequest = new SchemaInitRequest();
            schemaInitRequest.setDbConfig(dbConfig);
            schemaInitRequest.setTables(tables);
            log.info("Created SchemaInitRequest for agent: {}, dbConfig: {}, tables: {}", new Object[]{agentIdStr, dbConfig, tables});
            return this.vectorStoreService.schemaForAgent(agentIdStr, schemaInitRequest);
        }
        catch (Exception e) {
            log.error("Failed to initialize schema for agent: {} with datasource: {}", new Object[]{agentId, datasourceId, e});
            throw new RuntimeException("Failed to initialize schema for agent " + agentId + ": " + e.getMessage(), e);
        }
    }

    public String chatWithAgent(Long agentId, String query) {
        try {
            String agentIdStr = String.valueOf(agentId);
            log.info("Processing chat request for agent: {}, query: {}", (Object)agentIdStr, (Object)query);
            boolean hasData = this.vectorStoreService.getAgentVectorStoreManager().hasAgentData(agentIdStr);
            if (!hasData) {
                return "\u667a\u80fd\u4f53\u5c1a\u672a\u521d\u59cb\u5316\u6570\u636e\u6e90\uff0c\u8bf7\u5148\u5728\u300c\u521d\u59cb\u5316\u4fe1\u606f\u6e90\u300d\u4e2d\u914d\u7f6e\u6570\u636e\u6e90\u548c\u8868\u7ed3\u6784\u3002";
            }
            List<Map<String, Object>> datasources = this.getAgentDatasources(agentId);
            if (datasources.isEmpty()) {
                return "\u667a\u80fd\u4f53\u6ca1\u6709\u914d\u7f6e\u53ef\u7528\u7684\u6570\u636e\u6e90\uff0c\u8bf7\u5148\u914d\u7f6e\u6570\u636e\u6e90\u3002";
            }
            Map<String, Object> datasource = datasources.get(0);
            Datasource dsEntity = this.datasourceService.getDatasourceById((Integer)datasource.get("id"));
            if (dsEntity == null) {
                return "\u6570\u636e\u6e90\u914d\u7f6e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u6e90\u914d\u7f6e\u3002";
            }
            DbConfig dbConfig = this.createDbConfigFromDatasource(dsEntity);
            String response = this.processAgentQuery(agentIdStr, query, dbConfig);
            log.info("Generated response for agent: {}", (Object)agentIdStr);
            return response;
        }
        catch (Exception e) {
            log.error("Failed to process chat request for agent: {}", (Object)agentId, (Object)e);
            return "\u5904\u7406\u67e5\u8be2\u65f6\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage() + "\u3002\u8bf7\u68c0\u67e5\u6570\u636e\u6e90\u914d\u7f6e\u548c\u7f51\u7edc\u8fde\u63a5\u3002";
        }
    }

    private String processAgentQuery(String agentId, String query, DbConfig dbConfig) {
        try {
            if (this.isGreeting(query)) {
                return "\u60a8\u597d\uff01\u6211\u662f\u60a8\u7684\u6570\u636e\u5206\u6790\u52a9\u624b\u3002\u60a8\u53ef\u4ee5\u7528\u81ea\u7136\u8bed\u8a00\u8be2\u95ee\u6570\u636e\u76f8\u5173\u7684\u95ee\u9898\uff0c\u6211\u4f1a\u5e2e\u60a8\u67e5\u8be2\u548c\u5206\u6790\u6570\u636e\u3002\n\n\u4f8b\u5982\uff1a\n\u2022 \u67e5\u8be2\u7528\u6237\u603b\u6570\n\u2022 \u663e\u793a\u6700\u8fd1\u4e00\u5468\u7684\u8ba2\u5355\u7edf\u8ba1\n\u2022 \u5206\u6790\u9500\u552e\u8d8b\u52bf\n\n\u8bf7\u544a\u8bc9\u6211\u60a8\u60f3\u4e86\u89e3\u4ec0\u4e48\u6570\u636e\u4fe1\u606f\uff1f";
            }
            List relevantDocs = this.vectorStoreService.getAgentVectorStoreManager().similaritySearch(agentId, query, 10);
            if (relevantDocs.isEmpty()) {
                return "\u62b1\u6b49\uff0c\u6211\u6ca1\u6709\u627e\u5230\u4e0e\u60a8\u7684\u95ee\u9898\u76f8\u5173\u7684\u6570\u636e\u8868\u4fe1\u606f\u3002\u8bf7\u786e\u4fdd\u5df2\u6b63\u786e\u521d\u59cb\u5316\u6570\u636e\u6e90\uff0c\u6216\u8005\u5c1d\u8bd5\u7528\u4e0d\u540c\u7684\u65b9\u5f0f\u63cf\u8ff0\u60a8\u7684\u95ee\u9898\u3002";
            }
            StringBuilder response = new StringBuilder();
            response.append("\u6839\u636e\u60a8\u7684\u95ee\u9898\u300c").append(query).append("\u300d\uff0c\u6211\u627e\u5230\u4e86\u4ee5\u4e0b\u76f8\u5173\u4fe1\u606f\uff1a\n\n");
            HashSet<String> tables = new HashSet<String>();
            ArrayList<String> columns = new ArrayList<String>();
            for (Document doc : relevantDocs) {
                Map metadata = doc.getMetadata();
                String vectorType = (String)metadata.get("vectorType");
                if ("table".equals(vectorType)) {
                    tables.add((String)metadata.get("name"));
                    continue;
                }
                if (!"column".equals(vectorType)) continue;
                String tableName = (String)metadata.get("tableName");
                String columnName = (String)metadata.get("name");
                String description = (String)metadata.get("description");
                tables.add(tableName);
                columns.add(String.format("\u2022 %s.%s%s", tableName, columnName, description != null && !description.isEmpty() ? " - " + description : ""));
            }
            if (!tables.isEmpty()) {
                response.append("\ud83d\udcca **\u76f8\u5173\u6570\u636e\u8868\uff1a**\n");
                for (String table : tables) {
                    response.append("\u2022 ").append(table).append("\n");
                }
                response.append("\n");
            }
            if (!columns.isEmpty()) {
                response.append("\ud83d\udccb **\u76f8\u5173\u5b57\u6bb5\uff1a**\n");
                for (String column : columns.subList(0, Math.min(columns.size(), 8))) {
                    response.append(column).append("\n");
                }
                if (columns.size() > 8) {
                    response.append("... \u8fd8\u6709 ").append(columns.size() - 8).append(" \u4e2a\u76f8\u5173\u5b57\u6bb5\n");
                }
                response.append("\n");
            }
            response.append("\ud83d\udca1 **\u5efa\u8bae\uff1a**\n");
            response.append("\u57fa\u4e8e\u627e\u5230\u7684\u6570\u636e\u7ed3\u6784\uff0c\u60a8\u53ef\u4ee5\u8be2\u95ee\u66f4\u5177\u4f53\u7684\u95ee\u9898\uff0c\u6bd4\u5982\uff1a\n");
            if (tables.contains("users")) {
                response.append("\u2022 \u7528\u6237\u603b\u6570\u662f\u591a\u5c11\uff1f\n");
                response.append("\u2022 \u6700\u8fd1\u6ce8\u518c\u7684\u7528\u6237\u6709\u54ea\u4e9b\uff1f\n");
            }
            if (tables.contains("orders")) {
                response.append("\u2022 \u4eca\u5929\u7684\u8ba2\u5355\u6570\u91cf\u662f\u591a\u5c11\uff1f\n");
                response.append("\u2022 \u6700\u8fd1\u4e00\u5468\u7684\u9500\u552e\u989d\u662f\u591a\u5c11\uff1f\n");
            }
            if (tables.contains("products")) {
                response.append("\u2022 \u6709\u54ea\u4e9b\u4ea7\u54c1\u5206\u7c7b\uff1f\n");
                response.append("\u2022 \u6700\u53d7\u6b22\u8fce\u7684\u4ea7\u54c1\u662f\u4ec0\u4e48\uff1f\n");
            }
            response.append("\n\u26a0\ufe0f **\u6ce8\u610f\uff1a** \u5f53\u524d\u4e3a\u8c03\u8bd5\u6a21\u5f0f\uff0c\u663e\u793a\u7684\u662f\u6570\u636e\u7ed3\u6784\u5206\u6790\u3002\u5b8c\u6574\u7684SQL\u67e5\u8be2\u548c\u6570\u636e\u5206\u6790\u529f\u80fd\u6b63\u5728\u5f00\u53d1\u4e2d\u3002");
            return response.toString();
        }
        catch (Exception e) {
            log.error("Error processing agent query: {}", (Object)e.getMessage(), (Object)e);
            return "\u5904\u7406\u67e5\u8be2\u65f6\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage();
        }
    }

    private boolean isGreeting(String query) {
        String lowerQuery = query.toLowerCase().trim();
        return lowerQuery.matches(".*(\u4f60\u597d|hello|hi|\u60a8\u597d|\u55e8|hey).*") || lowerQuery.equals("\u4f60\u597d") || lowerQuery.equals("\u60a8\u597d") || lowerQuery.equals("hello") || lowerQuery.equals("hi");
    }
}

