/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.service;

import com.alibaba.cloud.ai.entity.BusinessKnowledge;
import com.alibaba.cloud.ai.entity.BusinessKnowledgeDTO;
import com.alibaba.cloud.ai.mapper.BusinessKnowledgeMapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusinessKnowledgePersistenceService {
    @Autowired
    private BusinessKnowledgeMapper businessKnowledgeMapper;

    public void addKnowledge(BusinessKnowledgeDTO knowledgeDTO) {
        BusinessKnowledge knowledge = new BusinessKnowledge();
        BeanUtils.copyProperties((Object)knowledgeDTO, (Object)knowledge);
        this.businessKnowledgeMapper.insert(knowledge);
    }

    public void addKnowledgeList(List<BusinessKnowledgeDTO> knowledgeDTOList) {
        for (BusinessKnowledgeDTO dto : knowledgeDTOList) {
            this.addKnowledge(dto);
        }
    }

    public List<String> getDataSetIds() {
        return this.businessKnowledgeMapper.selectDistinctDatasetIds();
    }

    public List<BusinessKnowledge> getFieldByDataSetId(String dataSetId) {
        return this.businessKnowledgeMapper.selectByDatasetId(dataSetId);
    }

    public List<BusinessKnowledge> searchFields(String keyword) {
        Objects.requireNonNull(keyword, "searchKeyword cannot be null");
        return this.businessKnowledgeMapper.searchByKeyword(keyword);
    }

    public void deleteFieldById(long id) {
        this.businessKnowledgeMapper.deleteById(Long.valueOf(id));
    }

    public void updateField(BusinessKnowledgeDTO knowledgeDTO, long id) {
        BusinessKnowledge knowledge = new BusinessKnowledge();
        BeanUtils.copyProperties((Object)knowledgeDTO, (Object)knowledge);
        knowledge.setId(id);
        this.businessKnowledgeMapper.updateById(knowledge);
    }

    public List<BusinessKnowledge> getKnowledgeByAgentId(String agentId) {
        return this.businessKnowledgeMapper.selectByAgentId(agentId);
    }

    public void deleteKnowledgeByAgentId(String agentId) {
        this.businessKnowledgeMapper.delete((Wrapper)Wrappers.lambdaQuery().eq(BusinessKnowledge::getAgentId, (Object)agentId));
    }

    public List<BusinessKnowledge> searchKnowledgeInAgent(String agentId, String keyword) {
        Objects.requireNonNull(agentId, "agentId cannot be null");
        Objects.requireNonNull(keyword, "searchKeyword cannot be null");
        return this.businessKnowledgeMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BusinessKnowledge::getAgentId, (Object)agentId)).and(wrapper -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.like(BusinessKnowledge::getBusinessTerm, (Object)keyword)).or()).like(BusinessKnowledge::getDescription, (Object)keyword)).or()).like(BusinessKnowledge::getSynonyms, (Object)keyword)));
    }
}

