/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.service;

import com.alibaba.cloud.ai.entity.ChatSession;
import com.alibaba.cloud.ai.mapper.ChatSessionMapper;
import java.time.LocalDateTime;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ChatSessionService {
    private static final Logger log = LoggerFactory.getLogger(ChatSessionService.class);
    @Autowired
    private ChatSessionMapper chatSessionMapper;

    public List<ChatSession> findByAgentId(Integer agentId) {
        return this.chatSessionMapper.selectByAgentId(agentId);
    }

    public ChatSession findById(String sessionId) {
        return this.chatSessionMapper.selectBySessionId(sessionId);
    }

    public ChatSession createSession(Integer agentId, String title, Long userId) {
        String sessionId = UUID.randomUUID().toString();
        ChatSession session = new ChatSession(sessionId, agentId, title != null ? title : "\u65b0\u5bf9\u8bdd", "active", userId);
        this.chatSessionMapper.insert(session);
        log.info("Created new chat session: {} for agent: {}", (Object)sessionId, (Object)agentId);
        return session;
    }

    public ChatSession updateSession(ChatSession session) {
        this.chatSessionMapper.updateById(session);
        log.info("Updated chat session: {}", (Object)session.getId());
        return session;
    }

    public void clearSessionsByAgentId(Integer agentId) {
        LocalDateTime now = LocalDateTime.now();
        int updated = this.chatSessionMapper.softDeleteByAgentId(agentId, now);
        log.info("Cleared {} sessions for agent: {}", (Object)updated, (Object)agentId);
    }

    public void updateSessionTime(String sessionId) {
        LocalDateTime now = LocalDateTime.now();
        this.chatSessionMapper.updateSessionTime(sessionId, now);
    }

    public void pinSession(String sessionId, boolean isPinned) {
        LocalDateTime now = LocalDateTime.now();
        this.chatSessionMapper.updatePinStatus(sessionId, isPinned, now);
        log.info("Updated pin status for session: {} to: {}", (Object)sessionId, (Object)isPinned);
    }

    public void renameSession(String sessionId, String newTitle) {
        LocalDateTime now = LocalDateTime.now();
        this.chatSessionMapper.updateTitle(sessionId, newTitle, now);
        log.info("Renamed session: {} to: {}", (Object)sessionId, (Object)newTitle);
    }

    public void deleteSession(String sessionId) {
        LocalDateTime now = LocalDateTime.now();
        this.chatSessionMapper.softDeleteById(sessionId, now);
        log.info("Deleted session: {}", (Object)sessionId);
    }
}

