/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.service;

import com.alibaba.cloud.ai.entity.SemanticModel;
import com.alibaba.cloud.ai.entity.SemanticModelDTO;
import com.alibaba.cloud.ai.mapper.SemanticModelMapper;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SemanticModelPersistenceService {
    @Autowired
    private SemanticModelMapper semanticModelMapper;

    public void addField(SemanticModelDTO semanticModelDTO) {
        SemanticModel semanticModel = new SemanticModel();
        BeanUtils.copyProperties((Object)semanticModelDTO, (Object)semanticModel);
        this.semanticModelMapper.insert(semanticModel);
    }

    public void addFields(List<SemanticModelDTO> semanticModelDTOS) {
        for (SemanticModelDTO dto : semanticModelDTOS) {
            this.addField(dto);
        }
    }

    public void enableFields(List<Long> ids) {
        for (Long id : ids) {
            this.semanticModelMapper.enableById(id);
        }
    }

    public void disableFields(List<Long> ids) {
        for (Long id : ids) {
            this.semanticModelMapper.disableById(id);
        }
    }

    public List<SemanticModel> getFieldByAgentId(Long agentId) {
        return this.semanticModelMapper.selectByAgentId(agentId);
    }

    public List<SemanticModel> searchFields(String keyword) {
        Objects.requireNonNull(keyword, "searchKeyword cannot be null");
        return this.semanticModelMapper.searchByKeyword(keyword);
    }

    public void deleteFieldById(long id) {
        this.semanticModelMapper.deleteById(Long.valueOf(id));
    }

    public void updateField(SemanticModelDTO semanticModelDTO, long id) {
        SemanticModel semanticModel = new SemanticModel();
        BeanUtils.copyProperties((Object)semanticModelDTO, (Object)semanticModel);
        semanticModel.setId(id);
        this.semanticModelMapper.updateById(semanticModel);
    }
}

