/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.service;

import com.alibaba.cloud.ai.entity.SemanticModel;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class SemanticModelService {
    private final Map<Long, SemanticModel> modelStore = new ConcurrentHashMap<Long, SemanticModel>();
    private final AtomicLong idGenerator = new AtomicLong(1L);

    public SemanticModelService() {
        this.initSampleData();
    }

    private void initSampleData() {
        SemanticModel model1 = new SemanticModel();
        model1.setAgentId(1L);
        model1.setOriginalFieldName("user_age");
        model1.setAgentFieldName("\u7528\u6237\u5e74\u9f84");
        model1.setFieldSynonyms("\u5e74\u9f84,\u5c81\u6570");
        model1.setFieldDescription("\u7528\u6237\u7684\u5b9e\u9645\u5e74\u9f84");
        model1.setDefaultRecall(true);
        model1.setEnabled(true);
        model1.setFieldType("INTEGER");
        model1.setOriginalDescription("\u7528\u6237\u5e74\u9f84\u5b57\u6bb5");
        this.save(model1);
        SemanticModel model2 = new SemanticModel();
        model2.setAgentId(1L);
        model2.setOriginalFieldName("product_name");
        model2.setAgentFieldName("\u5546\u54c1\u540d\u79f0");
        model2.setFieldSynonyms("\u4ea7\u54c1\u540d,\u5546\u54c1");
        model2.setFieldDescription("\u5546\u54c1\u7684\u540d\u79f0\u4fe1\u606f");
        model2.setDefaultRecall(false);
        model2.setEnabled(true);
        model2.setFieldType("VARCHAR");
        model2.setOriginalDescription("\u5546\u54c1\u540d\u79f0\u5b57\u6bb5");
        this.save(model2);
        SemanticModel model3 = new SemanticModel();
        model3.setAgentId(2L);
        model3.setOriginalFieldName("order_amount");
        model3.setAgentFieldName("\u8ba2\u5355\u91d1\u989d");
        model3.setFieldSynonyms("\u91d1\u989d,\u4ef7\u683c,\u8d39\u7528");
        model3.setFieldDescription("\u8ba2\u5355\u7684\u603b\u91d1\u989d");
        model3.setDefaultRecall(true);
        model3.setEnabled(true);
        model3.setFieldType("DECIMAL");
        model3.setOriginalDescription("\u8ba2\u5355\u91d1\u989d\u5b57\u6bb5");
        this.save(model3);
    }

    public List<SemanticModel> findAll() {
        return new ArrayList<SemanticModel>(this.modelStore.values());
    }

    public List<SemanticModel> findByAgentId(Long agentId) {
        return this.modelStore.values().stream().filter(m -> Objects.equals(m.getAgentId(), agentId)).collect(Collectors.toList());
    }

    public SemanticModel findById(Long id) {
        return this.modelStore.get(id);
    }

    public SemanticModel save(SemanticModel model) {
        if (model.getId() == null) {
            model.setId(this.idGenerator.getAndIncrement());
            model.setCreateTime(LocalDateTime.now());
        }
        model.setUpdateTime(LocalDateTime.now());
        this.modelStore.put(model.getId(), model);
        return model;
    }

    public void deleteById(Long id) {
        this.modelStore.remove(id);
    }

    public List<SemanticModel> search(String keyword) {
        if (keyword == null || keyword.trim().isEmpty()) {
            return this.findAll();
        }
        String lowerKeyword = keyword.toLowerCase();
        return this.modelStore.values().stream().filter(m -> m.getOriginalFieldName().toLowerCase().contains(lowerKeyword) || m.getAgentFieldName() != null && m.getAgentFieldName().toLowerCase().contains(lowerKeyword) || m.getFieldSynonyms() != null && m.getFieldSynonyms().toLowerCase().contains(lowerKeyword)).collect(Collectors.toList());
    }
}

