/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.memory.jdbc;

import com.alibaba.cloud.ai.memory.jdbc.JdbcChatMemoryRepository;
import org.springframework.jdbc.core.JdbcTemplate;

public class SQLiteChatMemoryRepository
extends JdbcChatMemoryRepository {
    private SQLiteChatMemoryRepository(JdbcTemplate jdbcTemplate) {
        super(jdbcTemplate);
    }

    public static SQLiteBuilder sqliteBuilder() {
        return new SQLiteBuilder();
    }

    @Override
    protected String hasTableSql(String tableName) {
        return String.format("SELECT name FROM sqlite_master WHERE type = 'table' AND name LIKE '%s'", tableName);
    }

    @Override
    protected String createTableSql(String tableName) {
        return String.format("CREATE TABLE IF NOT EXISTS %s ( conversation_id TEXT NOT NULL,    content TEXT NOT NULL, type TEXT NOT NULL, timestamp REAL NOT NULL,    CHECK (type IN ('USER', 'ASSISTANT', 'SYSTEM', 'TOOL')));", tableName);
    }

    public static class SQLiteBuilder {
        private JdbcTemplate jdbcTemplate;

        public SQLiteBuilder jdbcTemplate(JdbcTemplate jdbcTemplate) {
            this.jdbcTemplate = jdbcTemplate;
            return this;
        }

        public SQLiteChatMemoryRepository build() {
            return new SQLiteChatMemoryRepository(this.jdbcTemplate);
        }
    }
}

