/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.toolcalling.baidusearch;

import com.alibaba.cloud.ai.toolcalling.baidusearch.BaiduSearchProperties;
import com.alibaba.cloud.ai.toolcalling.baidusearch.BaiduSearchService;
import com.alibaba.cloud.ai.toolcalling.common.CommonToolCallConstants;
import com.alibaba.cloud.ai.toolcalling.common.CommonToolCallProperties;
import com.alibaba.cloud.ai.toolcalling.common.JsonParseTool;
import com.alibaba.cloud.ai.toolcalling.common.WebClientTool;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Description;
import org.springframework.http.HttpHeaders;

@Configuration
@EnableConfigurationProperties(value={BaiduSearchProperties.class})
@ConditionalOnProperty(prefix="spring.ai.alibaba.toolcalling.baidu.search", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class BaiduSearchAutoConfiguration {
    @Bean(name={"baiduSearch"})
    @ConditionalOnMissingBean
    @Description(value="Use baidu search engine to query for the latest news.")
    public BaiduSearchService baiduSearch(JsonParseTool jsonParseTool, BaiduSearchProperties properties) {
        Consumer<HttpHeaders> consumer = headers -> {
            headers.add("User-Agent", CommonToolCallConstants.DEFAULT_USER_AGENTS[ThreadLocalRandom.current().nextInt(CommonToolCallConstants.DEFAULT_USER_AGENTS.length)]);
            headers.add("Referer", "https://www.baidu.com/");
            headers.add("Connection", "keep-alive");
            headers.add("Accept-Language", "zh-CN,zh;q=0.9");
        };
        return new BaiduSearchService(jsonParseTool, properties, WebClientTool.builder((JsonParseTool)jsonParseTool, (CommonToolCallProperties)properties).httpHeadersConsumer(consumer).build());
    }
}

