/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.toolcalling.common;

import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public final class CommonToolCallUtils {
    private static final String URL_REGEX = "^(https?://)?((([a-zA-Z0-9\\-]+\\.)+[a-zA-Z]{2,})|(([0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})(?!(\\.0\\.0\\.0|\\.0\\.0|\\.0|\\.1|\\.2|\\.3|\\.4|\\.5|\\.6|\\.7|\\.8|\\.9))))(\\:[0-9]{1,5})?(/.*)?$";
    private static final Pattern pattern = Pattern.compile("^(https?://)?((([a-zA-Z0-9\\-]+\\.)+[a-zA-Z]{2,})|(([0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})(?!(\\.0\\.0\\.0|\\.0\\.0|\\.0|\\.1|\\.2|\\.3|\\.4|\\.5|\\.6|\\.7|\\.8|\\.9))))(\\:[0-9]{1,5})?(/.*)?$");

    private CommonToolCallUtils() {
    }

    public static <K, V> MultiValueMapBuilder<K, V> multiValueMapBuilder() {
        return new MultiValueMapBuilder();
    }

    public static <T> T handleServiceError(String serviceName, Supplier<T> operation, Logger logger) {
        try {
            return operation.get();
        }
        catch (Exception e) {
            logger.error("Failed to invoke {} service due to: {}", (Object)serviceName, (Object)e.getMessage());
            return null;
        }
    }

    public static boolean isInvalidateRequestParams(Object ... params) {
        return !Arrays.stream(params).allMatch(param -> param != null && (!(param instanceof String) || StringUtils.hasText((String)((String)param))));
    }

    public static <T> T handleResponse(String responseData, Function<String, T> parser, Logger logger) {
        if (responseData == null) {
            logger.error("Response data is null");
            return null;
        }
        try {
            return parser.apply(responseData);
        }
        catch (Exception e) {
            logger.error("Failed to handle response: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static boolean isValidUrl(String target) {
        if (!StringUtils.hasText((String)target)) {
            return false;
        }
        return pattern.matcher(target).matches();
    }

    public static class MultiValueMapBuilder<K, V> {
        private MultiValueMap<K, V> params = new LinkedMultiValueMap();

        private MultiValueMapBuilder() {
        }

        public MultiValueMapBuilder<K, V> add(K key, V value) {
            this.params.add(key, value);
            return this;
        }

        public MultiValueMap<K, V> build() {
            return this.params;
        }
    }
}

