/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.api;

import com.alibaba.cloud.ai.common.ModelType;
import com.alibaba.cloud.ai.common.R;
import com.alibaba.cloud.ai.model.ChatModelConfig;
import com.alibaba.cloud.ai.param.ModelRunActionParam;
import com.alibaba.cloud.ai.service.ChatModelDelegate;
import com.alibaba.cloud.ai.vo.ChatModelRunResult;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Tag(name="chat-model", description="the chat-model API")
public interface ChatModelAPI {
    default public ChatModelDelegate getDelegate() {
        return new ChatModelDelegate(){};
    }

    @Operation(summary="list chat models", description="", tags={"chat-model"})
    @GetMapping(value={""}, produces={"application/json"})
    default public R<List<ChatModelConfig>> list() {
        List<ChatModelConfig> res = this.getDelegate().list();
        return R.success(res);
    }

    @Operation(summary="get chat model by model name", description="", tags={"chat-model"})
    @GetMapping(value={"/{modelName}"}, produces={"application/json"})
    default public R<ChatModelConfig> get(@PathVariable String modelName) {
        ChatModelConfig res = this.getDelegate().getByModelName(modelName);
        return R.success(res);
    }

    @Operation(summary="run chat model by input", description="", tags={"chat-model"})
    @PostMapping(value={""}, consumes={"application/json"})
    default public R<ChatModelRunResult> run(@RequestBody ModelRunActionParam modelRunActionParam) {
        ChatModelRunResult res = this.getDelegate().run(modelRunActionParam);
        return R.success(res);
    }

    @Operation(summary="run image model by input", description="", tags={"chat-model"})
    @PostMapping(value={"/run/image-gen"}, consumes={"application/json"}, produces={"*/*"})
    default public void runImageGenTask(@RequestBody ModelRunActionParam modelRunActionParam, HttpServletResponse response) {
        String imageUrl = this.getDelegate().runImageGenTask(modelRunActionParam);
        try {
            URL url = new URL(imageUrl);
            InputStream in = url.openStream();
            response.setHeader("Content-Type", "image/png");
            response.getOutputStream().write(in.readAllBytes());
            response.getOutputStream().flush();
        }
        catch (IOException e) {
            response.setStatus(500);
        }
    }

    @Operation(summary="run image model by input, and url", description="", tags={"chat-model"})
    @RequestMapping(value={"/run/image-gen/url"}, method={RequestMethod.POST, RequestMethod.GET}, consumes={"application/json"}, produces={"*/*"})
    default public R<ChatModelRunResult> runImageGenTaskAndGetUrl(@RequestBody ModelRunActionParam modelRunActionParam) {
        return R.success(this.getDelegate().runImageGenTaskAndGetUrl(modelRunActionParam));
    }

    @Operation(summary="list model names", description="", tags={"chat-model"})
    @GetMapping(value={"model-names"}, produces={"application/json"})
    default public R<List<String>> listModelNames(@RequestParam(value="modelType") ModelType modelType) {
        List<String> res = this.getDelegate().listModelNames(modelType);
        return R.success(res);
    }
}

