/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.api;

import com.alibaba.cloud.ai.common.R;
import com.alibaba.cloud.ai.graph.GraphInitData;
import com.alibaba.cloud.ai.graph.StateGraph;
import com.alibaba.cloud.ai.graph.exception.GraphStateException;
import com.alibaba.cloud.ai.param.GraphStreamParam;
import com.alibaba.cloud.ai.service.GraphService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import reactor.core.publisher.Flux;

@Tag(name="Graph", description="the graph API")
public interface GraphAPI {
    public GraphService graphService();

    @Operation(summary="list graphs", description="", tags={"Graph"})
    @GetMapping(value={""}, produces={"application/json"})
    default public R<List<String>> list() {
        Map<String, StateGraph> graphMap = this.graphService().getStateGraphs();
        List graphNames = graphMap.keySet().stream().toList();
        return R.success(graphNames);
    }

    @Operation(summary="init graph", description="", tags={"Graph"})
    @GetMapping(value={"init"}, produces={"application/json"})
    default public R<GraphInitData> init(String name) throws GraphStateException {
        return R.success(this.graphService().getPrintableGraphData(name));
    }

    @Operation(summary="stream", description="", tags={"Graph"})
    @PostMapping(value={"stream"}, produces={"text/event-stream"})
    default public Flux<ServerSentEvent<String>> stream(HttpServletRequest request, String name, GraphStreamParam param) throws Exception {
        param.setSessionId(request.getSession().getId());
        return this.graphService().stream(name, param, (InputStream)request.getInputStream());
    }
}

