/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.function;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.springframework.ai.chat.messages.ToolResponseMessage;
import org.springframework.ai.chat.model.ToolContext;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.definition.ToolDefinition;
import org.springframework.ai.tool.resolution.TypeResolverHelper;
import org.springframework.ai.util.json.schema.SchemaType;
import org.springframework.util.Assert;

public class AgentFunctionCallbackWrapper<I, O>
implements BiFunction<I, ToolContext, O>,
ToolCallback {
    private final String name;
    private final String description;
    private final String inputTypeSchema;
    private final Class<I> inputType;
    private final ObjectMapper objectMapper;
    private final Function<O, String> responseConverter;
    private final BiFunction<I, ToolContext, O> biFunction;

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getInputTypeSchema() {
        return this.inputTypeSchema;
    }

    protected AgentFunctionCallbackWrapper(String name, String description, String inputTypeSchema, Class<I> inputType, Function<O, String> responseConverter, ObjectMapper objectMapper, BiFunction<I, ToolContext, O> function) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        Assert.notNull((Object)description, (String)"Description must not be null");
        Assert.notNull(inputType, (String)"InputType must not be null");
        Assert.notNull((Object)inputTypeSchema, (String)"InputTypeSchema must not be null");
        Assert.notNull(responseConverter, (String)"ResponseConverter must not be null");
        Assert.notNull((Object)objectMapper, (String)"ObjectMapper must not be null");
        Assert.notNull(function, (String)"Function must not be null");
        this.name = name;
        this.description = description;
        this.inputType = inputType;
        this.inputTypeSchema = inputTypeSchema;
        this.responseConverter = responseConverter;
        this.objectMapper = objectMapper;
        this.biFunction = function;
    }

    public O convertResponse(ToolResponseMessage.ToolResponse toolResponse) {
        try {
            Class<O> targetClass = AgentFunctionCallbackWrapper.resolveOutputType(this.biFunction);
            return (O)this.objectMapper.readValue(toolResponse.responseData(), targetClass);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public String call(String functionInput, ToolContext toolContext) {
        I request = this.fromJson(functionInput, this.inputType);
        O response = this.apply(request, toolContext);
        return this.responseConverter.apply(response);
    }

    public ToolDefinition getToolDefinition() {
        return ToolDefinition.builder().name(this.name).description(this.description).inputSchema(this.inputTypeSchema).build();
    }

    public String call(String functionArguments) {
        I request = this.fromJson(functionArguments, this.inputType);
        return this.andThen(this.responseConverter).apply(request, null);
    }

    private <T> T fromJson(String json, Class<T> targetClass) {
        try {
            return (T)this.objectMapper.readValue(json, targetClass);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public O apply(I input, ToolContext context) {
        return this.biFunction.apply(input, context);
    }

    private static <I, O> Class<O> resolveOutputType(BiFunction<I, ToolContext, O> biFunction) {
        return TypeResolverHelper.getBiFunctionArgumentClass(biFunction.getClass(), (int)2);
    }

    public static <I, O> Builder<I, O> builder(BiFunction<I, ToolContext, O> biFunction) {
        return new Builder<I, O>(biFunction);
    }

    public static <I, O> Builder<I, O> builder(Function<I, O> function) {
        return new Builder<I, O>(function);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgentFunctionCallbackWrapper that = (AgentFunctionCallbackWrapper)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.inputTypeSchema, that.inputTypeSchema) && Objects.equals(this.inputType, that.inputType) && Objects.equals(this.objectMapper, that.objectMapper) && Objects.equals(this.responseConverter, that.responseConverter) && Objects.equals(this.biFunction, that.biFunction);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.inputTypeSchema, this.inputType, this.objectMapper, this.responseConverter, this.biFunction);
    }

    public static class Builder<I, O> {
        private String name;
        private String description;
        private Class<I> inputType;
        private final BiFunction<I, ToolContext, O> biFunction;
        private final Function<I, O> function;
        private SchemaType schemaType = SchemaType.JSON_SCHEMA;
        private Function<O, String> responseConverter = ModelOptionsUtils::toJsonString;
        private String inputTypeSchema;
        private ObjectMapper objectMapper = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).registerModule((Module)new JavaTimeModule());

        public Builder(BiFunction<I, ToolContext, O> biFunction) {
            Assert.notNull(biFunction, (String)"Function must not be null");
            this.biFunction = biFunction;
            this.function = null;
        }

        public Builder(Function<I, O> function) {
            Assert.notNull(function, (String)"Function must not be null");
            this.biFunction = null;
            this.function = function;
        }

        public Builder<I, O> withName(String name) {
            Assert.hasText((String)name, (String)"Name must not be empty");
            this.name = name;
            return this;
        }

        public Builder<I, O> withDescription(String description) {
            Assert.hasText((String)description, (String)"Description must not be empty");
            this.description = description;
            return this;
        }

        public Builder<I, O> withInputType(Class<I> inputType) {
            this.inputType = inputType;
            return this;
        }

        public Builder<I, O> withResponseConverter(Function<O, String> responseConverter) {
            Assert.notNull(responseConverter, (String)"ResponseConverter must not be null");
            this.responseConverter = responseConverter;
            return this;
        }

        public Builder<I, O> withInputTypeSchema(String inputTypeSchema) {
            Assert.hasText((String)inputTypeSchema, (String)"InputTypeSchema must not be empty");
            this.inputTypeSchema = inputTypeSchema;
            return this;
        }

        public Builder<I, O> withObjectMapper(ObjectMapper objectMapper) {
            Assert.notNull((Object)objectMapper, (String)"ObjectMapper must not be null");
            this.objectMapper = objectMapper;
            return this;
        }

        public Builder<I, O> withSchemaType(SchemaType schemaType) {
            Assert.notNull((Object)schemaType, (String)"SchemaType must not be null");
            this.schemaType = schemaType;
            return this;
        }

        public AgentFunctionCallbackWrapper<I, O> build() {
            Assert.hasText((String)this.name, (String)"Name must not be empty");
            Assert.hasText((String)this.description, (String)"Description must not be empty");
            Assert.notNull(this.responseConverter, (String)"ResponseConverter must not be null");
            Assert.notNull((Object)this.objectMapper, (String)"ObjectMapper must not be null");
            if (this.inputType == null) {
                this.inputType = this.function != null ? Builder.resolveInputType(this.function) : Builder.resolveInputType(this.biFunction);
            }
            if (this.inputTypeSchema == null) {
                boolean upperCaseTypeValues = this.schemaType == SchemaType.OPEN_API_SCHEMA;
                this.inputTypeSchema = ModelOptionsUtils.getJsonSchema(this.inputType, (boolean)upperCaseTypeValues);
            }
            BiFunction<Object, ToolContext, Object> finalBiFunction = this.biFunction != null ? this.biFunction : (request, context) -> this.function.apply(request);
            return new AgentFunctionCallbackWrapper<I, O>(this.name, this.description, this.inputTypeSchema, this.inputType, this.responseConverter, this.objectMapper, finalBiFunction);
        }

        private static <I, O> Class<I> resolveInputType(BiFunction<I, ToolContext, O> biFunction) {
            return TypeResolverHelper.getBiFunctionInputClass(biFunction.getClass());
        }

        private static <I, O> Class<I> resolveInputType(Function<I, O> function) {
            return TypeResolverHelper.getFunctionInputClass(function.getClass());
        }
    }
}

