/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph;

import com.alibaba.cloud.ai.graph.NodeOutput;
import com.alibaba.cloud.ai.graph.state.StateSnapshot;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeOutputSerializer
extends StdSerializer<NodeOutput> {
    private static final Logger log = LoggerFactory.getLogger(NodeOutputSerializer.class);

    public NodeOutputSerializer() {
        super(NodeOutput.class);
    }

    public void serialize(NodeOutput nodeOutput, JsonGenerator gen, SerializerProvider serializerProvider) throws IOException {
        log.trace("NodeOutputSerializer start! {}", nodeOutput.getClass());
        gen.writeStartObject();
        if (nodeOutput instanceof StateSnapshot) {
            StateSnapshot snapshot = (StateSnapshot)nodeOutput;
            Optional checkpoint = snapshot.config().checkPointId();
            log.trace("checkpoint: {}", (Object)checkpoint);
            if (checkpoint.isPresent()) {
                gen.writeStringField("checkpoint", (String)checkpoint.get());
            }
        }
        if (nodeOutput.isSubGraph()) {
            gen.writeStringField("node", "_" + nodeOutput.node());
        } else {
            gen.writeStringField("node", nodeOutput.node());
        }
        gen.writeObjectField("state", (Object)nodeOutput.state().data());
        gen.writeEndObject();
    }
}

