/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.model;

import com.alibaba.cloud.ai.common.ModelType;
import com.alibaba.cloud.ai.dashscope.chat.DashScopeChatOptions;
import com.alibaba.cloud.ai.dashscope.image.DashScopeImageOptions;
import io.swagger.v3.oas.annotations.media.Schema;

public class ChatModelConfig {
    @Schema(description="ChatModel bean name", examples={"chatModel", "chatModel1"})
    private String name;
    @Schema(description="dashscope model name", examples={"qwen-plus", "qwen-turbo", "qwen-max", "qwen-max-longcontext"})
    private String model;
    private ModelType modelType;
    @Schema(nullable=true)
    private DashScopeChatOptions chatOptions;
    @Schema(nullable=true)
    private DashScopeImageOptions imageOptions;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public ModelType getModelType() {
        return this.modelType;
    }

    public void setModelType(ModelType modelType) {
        this.modelType = modelType;
    }

    public DashScopeChatOptions getChatOptions() {
        return this.chatOptions;
    }

    public void setChatOptions(DashScopeChatOptions chatOptions) {
        this.chatOptions = chatOptions;
    }

    public DashScopeImageOptions getImageOptions() {
        return this.imageOptions;
    }

    public void setImageOptions(DashScopeImageOptions imageOptions) {
        this.imageOptions = imageOptions;
    }

    public String toString() {
        return "ChatModelConfig{name='" + this.name + "', model='" + this.model + "', modelType=" + this.modelType + ", chatOptions=" + this.chatOptions + ", imageOptions=" + this.imageOptions + "}";
    }

    public static ChatModelConfigBuilder builder() {
        return new ChatModelConfigBuilder();
    }

    public static final class ChatModelConfigBuilder {
        private String name;
        private String model;
        private ModelType modelType;
        private DashScopeChatOptions chatOptions;
        private DashScopeImageOptions imageOptions;

        private ChatModelConfigBuilder() {
        }

        public static ChatModelConfigBuilder aChatModelConfig() {
            return new ChatModelConfigBuilder();
        }

        public ChatModelConfigBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ChatModelConfigBuilder model(String model) {
            this.model = model;
            return this;
        }

        public ChatModelConfigBuilder modelType(ModelType modelType) {
            this.modelType = modelType;
            return this;
        }

        public ChatModelConfigBuilder chatOptions(DashScopeChatOptions chatOptions) {
            this.chatOptions = chatOptions;
            return this;
        }

        public ChatModelConfigBuilder imageOptions(DashScopeImageOptions imageOptions) {
            this.imageOptions = imageOptions;
            return this;
        }

        public ChatModelConfig build() {
            ChatModelConfig chatModelConfig = new ChatModelConfig();
            chatModelConfig.setName(this.name);
            chatModelConfig.setModel(this.model);
            chatModelConfig.setModelType(this.modelType);
            chatModelConfig.setChatOptions(this.chatOptions);
            chatModelConfig.setImageOptions(this.imageOptions);
            return chatModelConfig;
        }
    }
}

