/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.service.impl;

import com.alibaba.cloud.ai.exception.NotFoundException;
import com.alibaba.cloud.ai.oltp.StudioObservabilityProperties;
import com.alibaba.cloud.ai.service.StudioObservabilityService;
import com.alibaba.cloud.ai.utils.FileUtils;
import com.alibaba.cloud.ai.utils.JsonUtil;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.io.SegmentedStringWriter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.opentelemetry.exporter.internal.otlp.traces.ResourceSpansMarshaler;
import io.opentelemetry.sdk.common.CompletableResultCode;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StudioObservabilityServiceImpl
implements StudioObservabilityService {
    private static final Logger logger = Logger.getLogger(StudioObservabilityServiceImpl.class.getName());
    private final ObjectMapper objectMapper;
    private final StudioObservabilityProperties studioObservabilityProperties;
    private final Path outputPath;
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private final List<String> keyPrefixes = List.of("gen_ai.operation", "spring.ai");

    public StudioObservabilityServiceImpl(StudioObservabilityProperties studioObservabilityProperties) {
        this.objectMapper = new ObjectMapper();
        this.studioObservabilityProperties = studioObservabilityProperties;
        this.outputPath = Path.of(studioObservabilityProperties.getOutputFile(), new String[0]);
    }

    @Override
    public CompletableResultCode export(Collection<ResourceSpansMarshaler> allResourceSpans) {
        try {
            FileUtils.createFileIfNotExists(this.outputPath);
            try (BufferedWriter writer = Files.newBufferedWriter(this.outputPath, StandardOpenOption.APPEND);){
                StringBuilder sb = new StringBuilder();
                for (ResourceSpansMarshaler resourceSpans : allResourceSpans) {
                    String json = this.generateJson(resourceSpans);
                    sb.append(json).append(LINE_SEPARATOR);
                    if (sb.length() <= 0x100000) continue;
                    writer.write(sb.toString());
                    sb.setLength(0);
                }
                if (!sb.isEmpty()) {
                    writer.write(sb.toString());
                }
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Error exporting spans to file", e);
            return CompletableResultCode.ofFailure();
        }
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public ArrayNode getAITraceInfo() {
        ArrayNode resultArray = this.objectMapper.createArrayNode();
        ArrayNode jsonArray = this.readObservabilityFile();
        block0: for (JsonNode jsonNode : jsonArray) {
            JsonNode scopeSpans = jsonNode.path("scopeSpans");
            JsonNode spans = scopeSpans.get(0).path("spans");
            for (JsonNode span : spans) {
                JsonNode attributes = span.path("attributes");
                boolean hasMatchingKey = false;
                for (JsonNode attribute : attributes) {
                    String key = attribute.path("key").asText();
                    if (!this.keyPrefixes.stream().anyMatch(key::startsWith)) continue;
                    hasMatchingKey = true;
                    break;
                }
                if (!hasMatchingKey) continue;
                resultArray.add(jsonNode);
                continue block0;
            }
        }
        return resultArray;
    }

    private String generateJson(ResourceSpansMarshaler resourceSpans) {
        String json;
        SegmentedStringWriter sw = new SegmentedStringWriter(JsonUtil.JSON_FACTORY._getBufferRecycler());
        try (JsonGenerator gen = JsonUtil.create(sw);){
            resourceSpans.writeJsonTo(gen);
            json = sw.getAndClear();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error generating OTLP JSON spans", e);
            return "";
        }
        return json;
    }

    @Override
    public ArrayNode readObservabilityFile() {
        ArrayNode jsonArray = this.objectMapper.createArrayNode();
        if (!this.outputPath.toFile().isFile()) {
            logger.log(Level.WARNING, "Invalid file path: " + this.studioObservabilityProperties.getOutputFile());
            return jsonArray;
        }
        try {
            List<String> lines = FileUtils.readLines(this.outputPath);
            for (String line : lines) {
                try {
                    JsonNode jsonNode = this.objectMapper.readTree(line);
                    jsonArray.add(jsonNode);
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Invalid JSON entry in file: " + line, e);
                }
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error reading JSON from file", e);
        }
        return jsonArray;
    }

    @Override
    public JsonNode getTraceByTraceId(String traceId) {
        ArrayNode jsonArray = this.readObservabilityFile();
        for (JsonNode jsonNode : jsonArray) {
            JsonNode scopeSpans = jsonNode.path("scopeSpans");
            JsonNode spans = scopeSpans.get(0).path("spans");
            JsonNode traceIdNode = spans.get(0).path("traceId");
            if (!traceIdNode.isTextual() || !traceIdNode.asText().equals(traceId)) continue;
            return jsonNode;
        }
        throw new NotFoundException("Not found trace info");
    }

    public List<ListResponse> extractSpansWithoutParentSpanId() {
        ArrayList<ListResponse> spanDataList = new ArrayList<ListResponse>();
        ArrayNode jsonArray = this.readObservabilityFile();
        block0: for (JsonNode jsonNode : jsonArray) {
            JsonNode scopeSpansNode = jsonNode.path("scopeSpans");
            boolean found = false;
            block1: for (JsonNode scopeSpan : scopeSpansNode) {
                JsonNode spansNode = scopeSpan.path("spans");
                if (found) continue block0;
                for (JsonNode span : spansNode) {
                    if (span.has("parentSpanId")) continue;
                    String traceId = span.path("traceId").asText();
                    String startTimeUnixNano = span.path("startTimeUnixNano").asText();
                    String endTimeUnixNano = span.path("endTimeUnixNano").asText();
                    ListResponse spanData = new ListResponse(traceId, spansNode.size(), startTimeUnixNano, endTimeUnixNano);
                    spanDataList.add(spanData);
                    found = true;
                    continue block1;
                }
            }
        }
        return spanDataList;
    }

    @Override
    public String clearExportContent() {
        try {
            Files.deleteIfExists(this.outputPath);
            logger.log(Level.INFO, "File content cleared.");
            return "File content cleared successfully.";
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Error clearing the file content", e);
            return "Error clearing the file content: " + e.getMessage();
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ListResponse(@JsonProperty(value="traceId") String traceId, @JsonProperty(value="spansSize") Integer spansSize, @JsonProperty(value="startTimeUnixNano") String startTimeUnixNano, @JsonProperty(value="endTimeUnixNano") String endTimeUnixNano) {
    }
}

