/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.tracing;

import io.micrometer.tracing.Tracer;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class TraceIdInterceptor
implements HandlerInterceptor {
    private final Tracer tracer;

    public TraceIdInterceptor(Tracer tracer) {
        this.tracer = tracer;
    }

    public boolean preHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler) {
        if (this.tracer.currentSpan() != null) {
            String traceId = this.tracer.currentSpan().context().traceId();
            response.setHeader("X-Trace-Id", traceId);
        }
        return true;
    }
}

