/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.dialect.impl;

import com.mybatisflex.core.dialect.KeywordWrap;
import com.mybatisflex.core.dialect.LimitOffsetProcessor;
import com.mybatisflex.core.dialect.impl.CommonsDialectImpl;
import com.mybatisflex.core.query.CPI;
import com.mybatisflex.core.query.QueryOrderBy;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.QueryWrapper;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DB2105Dialect
extends CommonsDialectImpl {
    public static final String DB2_1005_PRODUCT_VERSION = "1005";
    public static final String DB2_PRODUCT_NAME = "DB2";
    private static final Pattern ORDERBY_PATTERN = Pattern.compile("(\\S+)\\s+(\\S*)\\s*(" + " NULLS FIRST".trim() + "|" + " NULLS LAST".trim() + ")");
    private static final Pattern SUBSTRING_PATTERN = Pattern.compile("((?i)" + "SUBSTRING".trim() + ")(\\s*)(\\(.*?\\))");

    public DB2105Dialect(KeywordWrap keywordWrap, LimitOffsetProcessor limitOffsetProcessor) {
        super(keywordWrap, limitOffsetProcessor);
    }

    @Override
    public String buildSelectSql(QueryWrapper queryWrapper) {
        String sql = super.buildSelectSql(queryWrapper);
        if (sql != null) {
            Matcher matcher = SUBSTRING_PATTERN.matcher(sql);
            sql = matcher.replaceAll("SUBSTR$2$3");
        }
        return sql;
    }

    @Override
    protected void buildOrderBySql(StringBuilder sqlBuilder, QueryWrapper queryWrapper, List<QueryTable> queryTables) {
        List<QueryOrderBy> orderBys = CPI.getOrderBys(queryWrapper);
        if (orderBys != null && !orderBys.isEmpty()) {
            sqlBuilder.append(" ORDER BY ");
            int index = 0;
            for (QueryOrderBy orderBy : orderBys) {
                String orderBySql = orderBy.toSql(queryTables, this);
                orderBySql = this.convertOrderBySqlForDB2105(orderBySql);
                sqlBuilder.append(orderBySql);
                if (index != orderBys.size() - 1) {
                    sqlBuilder.append(", ");
                }
                ++index;
            }
        }
    }

    private String convertOrderBySqlForDB2105(String sql) {
        Matcher matcher = ORDERBY_PATTERN.matcher(sql);
        if (matcher.find()) {
            String column = matcher.group(1);
            String orderType = matcher.group(2);
            String nullOrder = matcher.group(3);
            if (" NULLS FIRST".trim().equals(nullOrder)) {
                sql = "CASE WHEN " + column + " IS NULL THEN 0 ELSE 1 END, " + column + " " + orderType;
            } else if (" NULLS LAST".trim().equals(nullOrder)) {
                sql = "CASE WHEN " + column + " IS NULL THEN 1 ELSE 0 END, " + column + " " + orderType;
            }
        }
        return sql;
    }

    public static interface DB2105LimitOffsetProcessor {
        public static final LimitOffsetProcessor DB2105 = (dialect, sql, queryWrapper, limitRows, limitOffset) -> {
            StringBuilder limitSqlFragment = new StringBuilder("select * from ( select u_.*,rownumber() over()  as rn from ( ");
            limitSqlFragment.append((CharSequence)sql);
            limitSqlFragment.append(" )u_  ) temp_ where temp_.rn between ");
            if (limitRows != null && limitOffset != null) {
                limitSqlFragment.append(limitOffset + 1L);
                limitSqlFragment.append(" and ");
                limitSqlFragment.append(limitRows + limitOffset);
            } else if (limitRows != null) {
                limitSqlFragment.append("1 and ");
                limitSqlFragment.append(limitRows);
            } else {
                return sql;
            }
            return limitSqlFragment;
        };
    }
}

