/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.activerecord;

import com.mybatisflex.core.BaseMapper;
import com.mybatisflex.core.mybatis.Mappers;
import com.mybatisflex.core.table.TableInfo;
import com.mybatisflex.core.table.TableInfoFactory;
import com.mybatisflex.core.util.SqlUtil;
import java.io.Serializable;
import java.util.Optional;

public interface MapperModel<T> {
    default public BaseMapper<T> baseMapper() {
        return Mappers.ofEntityClass(this.getClass());
    }

    default public Object pkValue() {
        TableInfo tableInfo = TableInfoFactory.ofEntityClass(this.getClass());
        return tableInfo.getPkValue(this);
    }

    default public boolean save() {
        return this.save(true);
    }

    default public Optional<T> saveOpt() {
        return this.saveOpt(true);
    }

    default public boolean save(boolean ignoreNulls) {
        return SqlUtil.toBool(this.baseMapper().insert(this, ignoreNulls));
    }

    default public Optional<T> saveOpt(boolean ignoreNulls) {
        return this.save(ignoreNulls) ? Optional.of(this) : Optional.empty();
    }

    default public boolean saveOrUpdate() {
        return this.saveOrUpdate(true);
    }

    default public Optional<T> saveOrUpdateOpt() {
        return this.saveOrUpdateOpt(true);
    }

    default public boolean saveOrUpdate(boolean ignoreNulls) {
        return SqlUtil.toBool(this.baseMapper().insertOrUpdate(this, ignoreNulls));
    }

    default public Optional<T> saveOrUpdateOpt(boolean ignoreNulls) {
        return this.saveOrUpdate(ignoreNulls) ? Optional.of(this) : Optional.empty();
    }

    default public boolean removeById() {
        return SqlUtil.toBool(this.baseMapper().deleteById((Serializable)this.pkValue()));
    }

    default public Optional<T> removeByIdOpt() {
        return this.removeById() ? Optional.of(this) : Optional.empty();
    }

    default public boolean updateById() {
        return this.updateById(true);
    }

    default public Optional<T> updateByIdOpt() {
        return this.updateByIdOpt(true);
    }

    default public boolean updateById(boolean ignoreNulls) {
        return SqlUtil.toBool(this.baseMapper().update(this, ignoreNulls));
    }

    default public Optional<T> updateByIdOpt(boolean ignoreNulls) {
        return this.updateById(ignoreNulls) ? Optional.of(this) : Optional.empty();
    }

    default public T oneById() {
        return this.baseMapper().selectOneById((Serializable)this.pkValue());
    }

    default public Optional<T> oneByIdOpt() {
        return Optional.ofNullable(this.oneById());
    }
}

