/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.logicdelete;

import com.mybatisflex.core.logicdelete.LogicDeleteProcessor;
import com.mybatisflex.core.logicdelete.impl.DefaultLogicDeleteProcessor;
import java.util.function.Supplier;

public class LogicDeleteManager {
    private static LogicDeleteProcessor processor = new DefaultLogicDeleteProcessor();
    private static final ThreadLocal<Boolean> skipFlags = new ThreadLocal();

    private LogicDeleteManager() {
    }

    public static LogicDeleteProcessor getProcessor() {
        return processor;
    }

    public static void setProcessor(LogicDeleteProcessor processor) {
        LogicDeleteManager.processor = processor;
    }

    public static <T> T execWithoutLogicDelete(Supplier<T> supplier) {
        try {
            LogicDeleteManager.skipLogicDelete();
            T t = supplier.get();
            return t;
        }
        finally {
            LogicDeleteManager.restoreLogicDelete();
        }
    }

    public static void execWithoutLogicDelete(Runnable runnable) {
        try {
            LogicDeleteManager.skipLogicDelete();
            runnable.run();
        }
        finally {
            LogicDeleteManager.restoreLogicDelete();
        }
    }

    public static void skipLogicDelete() {
        skipFlags.set(Boolean.TRUE);
    }

    public static void restoreLogicDelete() {
        skipFlags.remove();
    }

    public static String getLogicDeleteColumn(String logicDeleteColumn) {
        if (logicDeleteColumn == null) {
            return null;
        }
        Boolean skipFlag = skipFlags.get();
        if (skipFlag == null) {
            return logicDeleteColumn;
        }
        return skipFlag != false ? null : logicDeleteColumn;
    }
}

