/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.FlexConsts;
import com.mybatisflex.core.dialect.IDialect;
import com.mybatisflex.core.query.HasParamsColumn;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.WrapperUtil;
import java.util.List;

public class CastQueryColumn
extends QueryColumn
implements HasParamsColumn {
    private QueryColumn column;
    private final String dataType;

    public CastQueryColumn(QueryColumn column, String dataType) {
        this.column = column;
        this.dataType = dataType;
    }

    public CastQueryColumn(String column, String dataType) {
        this.column = new QueryColumn(column);
        this.dataType = dataType;
    }

    @Override
    protected String toConditionSql(List<QueryTable> queryTables, IDialect dialect) {
        return " CAST(" + this.column.toConditionSql(queryTables, dialect) + " AS " + this.dataType + ") ";
    }

    @Override
    protected String toSelectSql(List<QueryTable> queryTables, IDialect dialect) {
        return " CAST(" + this.column.toSelectSql(queryTables, dialect) + " AS " + this.dataType + ") " + WrapperUtil.buildColumnAlias(this.alias, dialect);
    }

    @Override
    public CastQueryColumn clone() {
        CastQueryColumn clone = (CastQueryColumn)super.clone();
        clone.column = this.column.clone();
        return clone;
    }

    @Override
    public String toString() {
        return "CastQueryColumn{column=" + this.column + ", dataType='" + this.dataType + '\'' + ", alias='" + this.alias + '\'' + '}';
    }

    @Override
    public Object[] getParamValues() {
        if (this.column instanceof HasParamsColumn) {
            return ((HasParamsColumn)((Object)this.column)).getParamValues();
        }
        return FlexConsts.EMPTY_ARRAY;
    }
}

