/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.exception;

import com.mybatisflex.core.exception.MybatisFlexException;

public final class FlexExceptions {
    private FlexExceptions() {
    }

    public static MybatisFlexException wrap(Throwable throwable) {
        if (throwable instanceof MybatisFlexException) {
            return (MybatisFlexException)throwable;
        }
        return new MybatisFlexException(throwable);
    }

    public static MybatisFlexException wrap(Throwable throwable, String msg, Object ... params) {
        return new MybatisFlexException(String.format(msg, params), throwable);
    }

    public static MybatisFlexException wrap(String msg, Object ... params) {
        return new MybatisFlexException(String.format(msg, params));
    }

    public static void assertTrue(boolean condition, String msg, Object ... params) {
        if (!condition) {
            throw FlexExceptions.wrap(msg, params);
        }
    }

    public static void assertNotNull(Object object, String msg, Object params) {
        FlexExceptions.assertTrue(object != null, msg, params);
    }

    public static <T> void assertAreNotNull(T[] elements, String msg, Object params) {
        if (elements == null || elements.length == 0) {
            throw FlexExceptions.wrap(msg, params);
        }
        for (T element : elements) {
            if (element != null) continue;
            throw FlexExceptions.wrap(msg, params);
        }
    }
}

