/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.provider;

import com.mybatisflex.core.FlexConsts;
import com.mybatisflex.core.dialect.DialectFactory;
import com.mybatisflex.core.exception.FlexAssert;
import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.provider.ProviderUtil;
import com.mybatisflex.core.query.CPI;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.row.Row;
import com.mybatisflex.core.row.RowCPI;
import com.mybatisflex.core.table.TableInfo;
import com.mybatisflex.core.table.TableInfoFactory;
import com.mybatisflex.core.util.ArrayUtil;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class RowSqlProvider {
    public static final String METHOD_RAW_SQL = "providerRawSql";

    private RowSqlProvider() {
    }

    public static String providerRawSql(Map params) {
        return ProviderUtil.getSqlString(params);
    }

    public static String insert(Map params) {
        String tableName = ProviderUtil.getTableName(params);
        String schema = ProviderUtil.getSchemaName(params);
        Row row = ProviderUtil.getRow(params);
        ProviderUtil.setSqlArgs(params, RowCPI.obtainModifyValues(row));
        return DialectFactory.getDialect().forInsertRow(schema, tableName, row);
    }

    public static String insertBatchWithFirstRowColumns(Map params) {
        List<Row> rows = ProviderUtil.getRows(params);
        FlexAssert.notEmpty(rows, "rows can not be null or empty.");
        String tableName = ProviderUtil.getTableName(params);
        String schema = ProviderUtil.getSchemaName(params);
        LinkedHashSet<String> modifyAttrs = new LinkedHashSet<String>(RowCPI.getModifyAttrs(rows.get(0)));
        rows.forEach(row -> row.keep(modifyAttrs));
        Object[] values = new Object[]{};
        for (Row row2 : rows) {
            values = ArrayUtil.concat(values, RowCPI.obtainModifyValues(row2));
        }
        ProviderUtil.setSqlArgs(params, values);
        return DialectFactory.getDialect().forInsertBatchWithFirstRowColumns(schema, tableName, rows);
    }

    public static String deleteById(Map params) {
        Object[] primaryValues = ProviderUtil.getPrimaryValues(params);
        FlexAssert.notEmpty(primaryValues, "primaryValue can not be null or empty.");
        String schema = ProviderUtil.getSchemaName(params);
        String tableName = ProviderUtil.getTableName(params);
        String[] primaryKeys = ProviderUtil.getPrimaryKeys(params);
        ProviderUtil.setSqlArgs(params, primaryValues);
        return DialectFactory.getDialect().forDeleteById(schema, tableName, primaryKeys);
    }

    public static String deleteBatchByIds(Map params) {
        String schema = ProviderUtil.getSchemaName(params);
        String tableName = ProviderUtil.getTableName(params);
        String[] primaryKeys = ProviderUtil.getPrimaryKeys(params);
        Object[] primaryValues = ProviderUtil.getPrimaryValues(params);
        ProviderUtil.setSqlArgs(params, primaryValues);
        return DialectFactory.getDialect().forDeleteBatchByIds(schema, tableName, primaryKeys, primaryValues);
    }

    public static String deleteByQuery(Map params) {
        String schema = ProviderUtil.getSchemaName(params);
        String tableName = ProviderUtil.getTableName(params);
        QueryWrapper queryWrapper = ProviderUtil.getQueryWrapper(params);
        CPI.setFromIfNecessary(queryWrapper, schema, tableName);
        String sql = DialectFactory.getDialect().forDeleteByQuery(queryWrapper);
        Object[] valueArray = CPI.getValueArray(queryWrapper);
        ProviderUtil.setSqlArgs(params, valueArray);
        return sql;
    }

    public static String updateById(Map params) {
        String schema = ProviderUtil.getSchemaName(params);
        String tableName = ProviderUtil.getTableName(params);
        Row row = ProviderUtil.getRow(params);
        ProviderUtil.setSqlArgs(params, RowCPI.obtainAllModifyValues(row));
        return DialectFactory.getDialect().forUpdateById(schema, tableName, row);
    }

    public static String updateByQuery(Map params) {
        String schema = ProviderUtil.getSchemaName(params);
        String tableName = ProviderUtil.getTableName(params);
        Row data = ProviderUtil.getRow(params);
        QueryWrapper queryWrapper = ProviderUtil.getQueryWrapper(params);
        CPI.setFromIfNecessary(queryWrapper, schema, tableName);
        String sql = DialectFactory.getDialect().forUpdateByQuery(queryWrapper, data);
        Object[] modifyValues = RowCPI.obtainModifyValues(data);
        Object[] valueArray = CPI.getValueArray(queryWrapper);
        ProviderUtil.setSqlArgs(params, ArrayUtil.concat(modifyValues, valueArray));
        return sql;
    }

    public static String updateBatchById(Map params) {
        List<Row> rows = ProviderUtil.getRows(params);
        FlexAssert.notEmpty(rows, "rows can not be null or empty.");
        String schema = ProviderUtil.getSchemaName(params);
        String tableName = ProviderUtil.getTableName(params);
        Object[] values = FlexConsts.EMPTY_ARRAY;
        for (Row row : rows) {
            values = ArrayUtil.concat(values, RowCPI.obtainAllModifyValues(row));
        }
        ProviderUtil.setSqlArgs(params, values);
        return DialectFactory.getDialect().forUpdateBatchById(schema, tableName, rows);
    }

    public static String updateEntity(Map params) {
        Object entity = ProviderUtil.getEntity(params);
        FlexAssert.notNull(entity, "entity can not be null");
        TableInfo tableInfo = TableInfoFactory.ofEntityClass(entity.getClass());
        tableInfo.invokeOnUpdateListener(entity);
        Object[] updateValues = tableInfo.buildUpdateSqlArgs(entity, false, false);
        Object[] primaryValues = tableInfo.buildPkSqlArgs(entity);
        Object[] tenantIdArgs = tableInfo.buildTenantIdArgs();
        FlexExceptions.assertAreNotNull(primaryValues, "The value of primary key must not be null, entity[%s]", entity);
        ProviderUtil.setSqlArgs(params, ArrayUtil.concat(updateValues, primaryValues, tenantIdArgs, new Object[0][]));
        return DialectFactory.getDialect().forUpdateEntity(tableInfo, entity, false);
    }

    public static String updateNumberAddByQuery(Map params) {
        QueryWrapper queryWrapper = ProviderUtil.getQueryWrapper(params);
        String schema = ProviderUtil.getSchemaName(params);
        String tableName = ProviderUtil.getTableName(params);
        String fieldName = ProviderUtil.getFieldName(params);
        Number value = (Number)ProviderUtil.getValue(params);
        String sql = DialectFactory.getDialect().forUpdateNumberAddByQuery(schema, tableName, fieldName, value, queryWrapper);
        Object[] queryParams = CPI.getValueArray(queryWrapper);
        ProviderUtil.setSqlArgs(params, queryParams);
        return sql;
    }

    public static String selectOneById(Map params) {
        String schema = ProviderUtil.getSchemaName(params);
        String tableName = ProviderUtil.getTableName(params);
        String[] primaryKeys = ProviderUtil.getPrimaryKeys(params);
        Object[] primaryValues = ProviderUtil.getPrimaryValues(params);
        ProviderUtil.setSqlArgs(params, primaryValues);
        return DialectFactory.getDialect().forSelectOneById(schema, tableName, primaryKeys, primaryValues);
    }

    public static String selectListByQuery(Map params) {
        String schema = ProviderUtil.getSchemaName(params);
        String tableName = ProviderUtil.getTableName(params);
        QueryWrapper queryWrapper = ProviderUtil.getQueryWrapper(params);
        CPI.setFromIfNecessary(queryWrapper, schema, tableName);
        String sql = DialectFactory.getDialect().forSelectByQuery(queryWrapper);
        Object[] valueArray = CPI.getValueArray(queryWrapper);
        ProviderUtil.setSqlArgs(params, valueArray);
        return sql;
    }
}

