/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.dialect.IDialect;
import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.query.ArithmeticQueryColumn;
import com.mybatisflex.core.query.CloneSupport;
import com.mybatisflex.core.query.QueryCondition;
import com.mybatisflex.core.query.QueryOrderBy;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.query.WrapperUtil;
import com.mybatisflex.core.table.TableDef;
import com.mybatisflex.core.util.CollectionUtil;
import com.mybatisflex.core.util.LambdaGetter;
import com.mybatisflex.core.util.LambdaUtil;
import com.mybatisflex.core.util.ObjectUtil;
import com.mybatisflex.core.util.SqlUtil;
import com.mybatisflex.core.util.StringUtil;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;

public class QueryColumn
implements CloneSupport<QueryColumn> {
    protected QueryTable table;
    protected String name;
    protected String alias;
    private boolean returnCopyByAsMethod = false;

    public QueryColumn() {
    }

    public QueryColumn(String name) {
        SqlUtil.keepColumnSafely(name);
        this.name = StringUtil.tryTrim(name);
    }

    public QueryColumn(String tableName, String name) {
        SqlUtil.keepColumnSafely(name);
        this.table = new QueryTable(tableName);
        this.name = StringUtil.tryTrim(name);
    }

    public QueryColumn(String schema, String tableName, String name) {
        SqlUtil.keepColumnSafely(name);
        this.table = new QueryTable(schema, tableName);
        this.name = StringUtil.tryTrim(name);
    }

    public QueryColumn(String schema, String tableName, String name, String alias) {
        SqlUtil.keepColumnSafely(name);
        this.returnCopyByAsMethod = true;
        this.table = new QueryTable(schema, tableName);
        this.name = StringUtil.tryTrim(name);
        this.alias = StringUtil.tryTrim(alias);
    }

    public QueryColumn(QueryTable queryTable, String name) {
        SqlUtil.keepColumnSafely(name);
        this.table = queryTable;
        this.name = StringUtil.tryTrim(name);
    }

    public QueryColumn(TableDef tableDef, String name) {
        this(tableDef, name, null);
    }

    public QueryColumn(TableDef tableDef, String name, String alias) {
        SqlUtil.keepColumnSafely(name);
        this.returnCopyByAsMethod = true;
        this.table = new QueryTable(tableDef);
        this.name = name;
        this.alias = alias;
    }

    public QueryTable getTable() {
        return this.table;
    }

    public void setTable(QueryTable table) {
        this.table = table;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public <T> QueryColumn as(LambdaGetter<T> fn) {
        return this.as(fn, false);
    }

    public <T> QueryColumn as(LambdaGetter<T> fn, boolean withPrefix) {
        return this.as(LambdaUtil.getAliasName(fn, withPrefix));
    }

    public QueryColumn as(String alias) {
        SqlUtil.keepColumnSafely(alias);
        if (this.returnCopyByAsMethod) {
            QueryColumn newColumn = new QueryColumn();
            newColumn.table = this.table;
            newColumn.name = this.name;
            newColumn.alias = alias;
            return newColumn;
        }
        this.alias = alias;
        return this;
    }

    public QueryCondition eq(Object value) {
        if (value == null) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " = ", value);
    }

    public <T> QueryCondition eq(Object value, Predicate<T> fn) {
        if (value == null) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " = ", value).when(fn);
    }

    public QueryCondition ne(Object value) {
        if (value == null) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " != ", value);
    }

    public <T> QueryCondition ne(Object value, Predicate<T> fn) {
        if (value == null) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " != ", value).when(fn);
    }

    public QueryCondition like(Object value) {
        if (value == null) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " LIKE ", "%" + value + "%");
    }

    public <T> QueryCondition like(Object value, Predicate<T> fn) {
        if (value == null) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " LIKE ", "%" + value + "%").when(fn);
    }

    public QueryCondition likeLeft(Object value) {
        if (value == null) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " LIKE ", value + "%");
    }

    public <T> QueryCondition likeLeft(Object value, Predicate<T> fn) {
        if (value == null) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " LIKE ", value + "%").when(fn);
    }

    public QueryCondition likeRight(Object value) {
        if (value == null) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " LIKE ", "%" + value);
    }

    public <T> QueryCondition likeRight(Object value, Predicate<T> fn) {
        if (value == null) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " LIKE ", "%" + value).when(fn);
    }

    public QueryCondition gt(Object value) {
        if (value == null) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " > ", value);
    }

    public <T> QueryCondition gt(Object value, Predicate<T> fn) {
        if (value == null) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " > ", value).when(fn);
    }

    public QueryCondition ge(Object value) {
        if (value == null) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " >= ", value);
    }

    public <T> QueryCondition ge(Object value, Predicate<T> fn) {
        if (value == null) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " >= ", value).when(fn);
    }

    public QueryCondition lt(Object value) {
        if (value == null) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " < ", value);
    }

    public <T> QueryCondition lt(Object value, Predicate<T> fn) {
        if (value == null) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " < ", value).when(fn);
    }

    public QueryCondition le(Object value) {
        if (value == null) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " <= ", value);
    }

    public <T> QueryCondition le(Object value, Predicate<T> fn) {
        if (value == null) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " <= ", value).when(fn);
    }

    public QueryCondition isNull() {
        return QueryCondition.create(this, " IS NULL ", null);
    }

    public <T> QueryCondition isNull(Predicate<T> fn) {
        return QueryCondition.create(this, " IS NULL ", null).when(fn);
    }

    public QueryCondition isNotNull() {
        return QueryCondition.create(this, " IS NOT NULL ", null);
    }

    public <T> QueryCondition isNotNull(Predicate<T> fn) {
        return QueryCondition.create(this, " IS NOT NULL ", null).when(fn);
    }

    public QueryCondition in(Object ... arrays) {
        if (arrays == null || arrays.length == 0 || arrays.length == 1 && arrays[0] == null) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " IN ", arrays);
    }

    public <T> QueryCondition in(Object[] arrays, Predicate<T> fn) {
        if (arrays == null || arrays.length == 0 || arrays.length == 1 && arrays[0] == null) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " IN ", arrays).when(fn);
    }

    public QueryCondition in(QueryWrapper queryWrapper) {
        return QueryCondition.create(this, " IN ", queryWrapper);
    }

    public <T> QueryCondition in(QueryWrapper queryWrapper, Predicate<T> fn) {
        return QueryCondition.create(this, " IN ", queryWrapper).when(fn);
    }

    public QueryCondition in(Collection<?> collection) {
        if (collection != null && !collection.isEmpty()) {
            return this.in(collection.toArray());
        }
        return QueryCondition.createEmpty();
    }

    public <T> QueryCondition in(Collection<?> collection, Predicate<T> fn) {
        if (collection != null && !collection.isEmpty()) {
            return this.in(collection.toArray(), fn);
        }
        return QueryCondition.createEmpty();
    }

    public QueryCondition notIn(Object ... arrays) {
        if (arrays == null || arrays.length == 0 || arrays.length == 1 && arrays[0] == null) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " NOT IN ", arrays);
    }

    public <T> QueryCondition notIn(Object[] arrays, Predicate<T> fn) {
        if (arrays == null || arrays.length == 0 || arrays.length == 1 && arrays[0] == null) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " NOT IN ", arrays).when(fn);
    }

    public QueryCondition notIn(Collection<?> collection) {
        if (collection != null && !collection.isEmpty()) {
            return this.notIn(collection.toArray());
        }
        return QueryCondition.createEmpty();
    }

    public <T> QueryCondition notIn(Collection<?> collection, Predicate<T> fn) {
        if (collection != null && !collection.isEmpty()) {
            return this.notIn(collection.toArray(), fn);
        }
        return QueryCondition.createEmpty();
    }

    public QueryCondition notIn(QueryWrapper queryWrapper) {
        return QueryCondition.create(this, " NOT IN ", queryWrapper);
    }

    public <T> QueryCondition notIn(QueryWrapper queryWrapper, Predicate<T> fn) {
        return QueryCondition.create(this, " NOT IN ", queryWrapper).when(fn);
    }

    public QueryCondition between(Object start, Object end) {
        return QueryCondition.create(this, " BETWEEN ", new Object[]{start, end});
    }

    public <T> QueryCondition between(Object start, Object end, Predicate<T> fn) {
        return QueryCondition.create(this, " BETWEEN ", new Object[]{start, end}).when(fn);
    }

    public QueryCondition notBetween(Object start, Object end) {
        return QueryCondition.create(this, " NOT BETWEEN ", new Object[]{start, end});
    }

    public <T> QueryCondition notBetween(Object start, Object end, Predicate<T> fn) {
        return QueryCondition.create(this, " NOT BETWEEN ", new Object[]{start, end}).when(fn);
    }

    public QueryOrderBy asc() {
        return new QueryOrderBy(this, " ASC");
    }

    public QueryOrderBy desc() {
        return new QueryOrderBy(this, " DESC");
    }

    public QueryColumn add(QueryColumn queryColumn) {
        return new ArithmeticQueryColumn(this).add(queryColumn);
    }

    public QueryColumn add(Number number) {
        return new ArithmeticQueryColumn(this).add(number);
    }

    public QueryColumn subtract(QueryColumn queryColumn) {
        return new ArithmeticQueryColumn(this).subtract(queryColumn);
    }

    public QueryColumn subtract(Number number) {
        return new ArithmeticQueryColumn(this).subtract(number);
    }

    public QueryColumn multiply(QueryColumn queryColumn) {
        return new ArithmeticQueryColumn(this).multiply(queryColumn);
    }

    public QueryColumn multiply(Number number) {
        return new ArithmeticQueryColumn(this).multiply(number);
    }

    public QueryColumn divide(QueryColumn queryColumn) {
        return new ArithmeticQueryColumn(this).divide(queryColumn);
    }

    public QueryColumn divide(Number number) {
        return new ArithmeticQueryColumn(this).divide(number);
    }

    String toConditionSql(List<QueryTable> queryTables, IDialect dialect) {
        QueryTable selectTable = this.getSelectTable(queryTables, this.table);
        if (selectTable == null) {
            return dialect.wrap(this.name);
        }
        if (StringUtil.isNotBlank(selectTable.alias)) {
            return dialect.wrap(selectTable.alias) + "." + dialect.wrap(this.name);
        }
        if (StringUtil.isNotBlank(selectTable.getSchema()) && StringUtil.isNotBlank(selectTable.getName())) {
            return dialect.wrap(dialect.getRealSchema(selectTable.schema)) + "." + dialect.wrap(dialect.getRealTable(selectTable.getName())) + "." + dialect.wrap(this.name);
        }
        if (StringUtil.isNotBlank(selectTable.getName())) {
            return dialect.wrap(dialect.getRealTable(selectTable.getName())) + "." + dialect.wrap(this.name);
        }
        return dialect.wrap(this.name);
    }

    String toSelectSql(List<QueryTable> queryTables, IDialect dialect) {
        return this.toConditionSql(queryTables, dialect) + WrapperUtil.buildAlias(this.alias, dialect);
    }

    QueryTable getSelectTable(List<QueryTable> queryTables, QueryTable columnTable) {
        if (queryTables == null || queryTables.isEmpty()) {
            return null;
        }
        if (queryTables.size() == 1 && queryTables.get(0).isSameTable(columnTable)) {
            return null;
        }
        if (CollectionUtil.isEmpty(queryTables)) {
            return columnTable;
        }
        if (columnTable == null && queryTables.size() == 1) {
            return queryTables.get(0);
        }
        for (QueryTable table : queryTables) {
            if (!table.isSameTable(columnTable)) continue;
            return table;
        }
        return columnTable;
    }

    public String toString() {
        return "QueryColumn{table=" + this.table + ", name='" + this.name + '\'' + ", alias='" + this.alias + '\'' + '}';
    }

    @Override
    public QueryColumn clone() {
        try {
            QueryColumn clone = (QueryColumn)super.clone();
            clone.table = ObjectUtil.clone(this.table);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw FlexExceptions.wrap(e);
        }
    }
}

