/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.transaction;

import java.io.IOException;
import org.apache.ibatis.cursor.Cursor;

public class TransactionContext {
    private static final ThreadLocal<String> XID_HOLDER = new ThreadLocal();
    private static final ThreadLocal<Cursor<?>> CURSOR_HOLDER = new ThreadLocal();

    private TransactionContext() {
    }

    public static String getXID() {
        return XID_HOLDER.get();
    }

    public static void release() {
        XID_HOLDER.remove();
        TransactionContext.closeCursor();
    }

    private static void closeCursor() {
        try {
            Cursor<?> cursor = CURSOR_HOLDER.get();
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        finally {
            CURSOR_HOLDER.remove();
        }
    }

    public static void holdXID(String xid) {
        XID_HOLDER.set(xid);
    }

    public static void holdCursor(Cursor<?> cursor) {
        CURSOR_HOLDER.set(cursor);
    }
}

