/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.util;

import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.table.TableInfo;
import com.mybatisflex.core.table.TableInfoFactory;
import com.mybatisflex.core.util.LambdaGetter;
import com.mybatisflex.core.util.StringUtil;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.reflection.property.PropertyNamer;
import org.apache.ibatis.util.MapUtil;

public class LambdaUtil {
    private static final Map<Class<?>, SerializedLambda> lambdaMap = new ConcurrentHashMap();
    private static final Map<String, Class<?>> classMap = new ConcurrentHashMap();

    private LambdaUtil() {
    }

    public static <T> String getFieldName(LambdaGetter<T> getter) {
        SerializedLambda lambda = LambdaUtil.getSerializedLambda(getter);
        String methodName = lambda.getImplMethodName();
        return PropertyNamer.methodToProperty((String)methodName);
    }

    public static <T> String getAliasName(LambdaGetter<T> getter, boolean withPrefix) {
        QueryColumn queryColumn = LambdaUtil.getQueryColumn(getter);
        String alias = StringUtil.isNotBlank(queryColumn.getAlias()) ? queryColumn.getAlias() : queryColumn.getName();
        return withPrefix ? queryColumn.getTable().getName() + "$" + alias : alias;
    }

    public static <T> QueryColumn getQueryColumn(LambdaGetter<T> getter) {
        SerializedLambda lambda = LambdaUtil.getSerializedLambda(getter);
        String methodName = lambda.getImplMethodName();
        String implClass = LambdaUtil.getImplClass(lambda);
        Class entityClass = (Class)MapUtil.computeIfAbsent(classMap, (Object)implClass, s -> {
            try {
                return Class.forName(s.replace("/", "."));
            }
            catch (ClassNotFoundException e) {
                throw FlexExceptions.wrap(e);
            }
        });
        TableInfo tableInfo = TableInfoFactory.ofEntityClass(entityClass);
        return tableInfo.getQueryColumnByProperty(PropertyNamer.methodToProperty((String)methodName));
    }

    private static SerializedLambda getSerializedLambda(Serializable getter) {
        return (SerializedLambda)MapUtil.computeIfAbsent(lambdaMap, getter.getClass(), aClass -> {
            try {
                Method method = getter.getClass().getDeclaredMethod("writeReplace", new Class[0]);
                method.setAccessible(Boolean.TRUE);
                return (SerializedLambda)method.invoke((Object)getter, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static String getImplClass(SerializedLambda lambda) {
        String type = lambda.getInstantiatedMethodType();
        return type.substring(2, type.indexOf(";"));
    }
}

