/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.provider;

import com.mybatisflex.core.FlexConsts;
import com.mybatisflex.core.exception.FlexAssert;
import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.exception.locale.LocalizedFormats;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.row.Row;
import com.mybatisflex.core.table.TableInfo;
import com.mybatisflex.core.table.TableInfoFactory;
import com.mybatisflex.core.util.StringUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.builder.annotation.ProviderContext;

class ProviderUtil {
    private ProviderUtil() {
    }

    public static String getSqlString(Map params) {
        return (String)params.get("$$sql");
    }

    public static void setSqlArgs(Map params, Object[] args) {
        params.put("$$sql_args", args);
    }

    public static String getSchemaName(Map params) {
        Object schemaNameObj = params.get("$$schemaName");
        return schemaNameObj != null ? schemaNameObj.toString().trim() : null;
    }

    public static String getTableName(Map params) {
        Object tableNameObj = params.get("$$tableName");
        return tableNameObj != null ? tableNameObj.toString().trim() : null;
    }

    public static String[] getPrimaryKeys(Map params) {
        String primaryKey = (String)params.get("$$primaryKey");
        if (StringUtil.isBlank(primaryKey)) {
            throw FlexExceptions.wrap(LocalizedFormats.OBJECT_NULL_OR_BLANK, "primaryKey");
        }
        String[] primaryKeys = primaryKey.split(",");
        for (int i = 0; i < primaryKeys.length; ++i) {
            primaryKeys[i] = primaryKeys[i].trim();
        }
        return primaryKeys;
    }

    public static Object[] getPrimaryValues(Map params) {
        Object primaryValue = params.get("$$primaryValue");
        if (primaryValue == null) {
            return FlexConsts.EMPTY_ARRAY;
        }
        if (primaryValue.getClass().isArray()) {
            return (Object[])primaryValue;
        }
        if (primaryValue instanceof Collection) {
            return ((Collection)primaryValue).toArray();
        }
        return new Object[]{primaryValue};
    }

    public static QueryWrapper getQueryWrapper(Map params) {
        Object queryWrapper = params.get("$$query");
        FlexAssert.notNull(queryWrapper, "queryWrapper");
        return (QueryWrapper)queryWrapper;
    }

    public static Row getRow(Map params) {
        return (Row)params.get("$$row");
    }

    public static List<Row> getRows(Map params) {
        return (List)params.get("$$rows");
    }

    public static TableInfo getTableInfo(ProviderContext context) {
        return TableInfoFactory.ofMapperClass(context.getMapperType());
    }

    public static Object getEntity(Map params) {
        return params.get("$$entity");
    }

    public static String getFieldName(Map params) {
        return (String)params.get("$$fieldName");
    }

    public static Object getValue(Map params) {
        return params.get("$$value");
    }

    public static List<Object> getEntities(Map params) {
        return (List)params.get("$$entities");
    }

    public static boolean isIgnoreNulls(Map params) {
        return params.containsKey("$$ignoreNulls") && (Boolean)params.get("$$ignoreNulls") != false;
    }
}

