/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.spring.boot;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.text.Normalizer;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ibatis.io.VFS;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public class SpringBootVFS
extends VFS {
    private static Charset urlDecodingCharset;
    private final ResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver(((Object)((Object)this)).getClass().getClassLoader());

    public static void setUrlDecodingCharset(Charset charset) {
        urlDecodingCharset = charset;
    }

    private static String preserveSubpackageName(String baseUrlString, Resource resource, String rootPath) {
        try {
            return rootPath + (rootPath.endsWith("/") ? "" : "/") + Normalizer.normalize(URLDecoder.decode(resource.getURL().toString(), urlDecodingCharset.name()), Normalizer.Form.NFC).substring(baseUrlString.length());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public boolean isValid() {
        return true;
    }

    protected List<String> list(URL url, String path) throws IOException {
        String urlString = URLDecoder.decode(url.toString(), urlDecodingCharset.name());
        String baseUrlString = urlString.endsWith("/") ? urlString : urlString.concat("/");
        Resource[] resources = this.resourceResolver.getResources(baseUrlString + "**/*.class");
        return Stream.of(resources).map(resource -> SpringBootVFS.preserveSubpackageName(baseUrlString, resource, path)).collect(Collectors.toList());
    }

    static {
        SpringBootVFS.setUrlDecodingCharset(Charset.defaultCharset());
    }
}

