/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.spring.boot;

import com.mybatisflex.core.datasource.DataSourceBuilder;
import com.mybatisflex.core.datasource.FlexDataSource;
import com.mybatisflex.spring.boot.ConditionalOnMybatisFlexDatasource;
import com.mybatisflex.spring.boot.MybatisFlexProperties;
import com.mybatisflex.spring.datasource.DataSourceAdvice;
import com.mybatisflex.spring.datasource.DataSourceInterceptor;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnMybatisFlexDatasource
@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={MybatisFlexProperties.class})
@ConditionalOnClass(value={SqlSessionFactory.class, SqlSessionFactoryBean.class})
@AutoConfigureBefore(value={DataSourceAutoConfiguration.class}, name={"com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceAutoConfigure"})
public class MultiDataSourceAutoConfiguration {
    private final Map<String, Map<String, String>> dataSourceProperties;

    public MultiDataSourceAutoConfiguration(MybatisFlexProperties properties) {
        this.dataSourceProperties = properties.getDatasource();
    }

    @Bean
    @ConditionalOnMissingBean
    public DataSource dataSource() {
        FlexDataSource flexDataSource = null;
        if (this.dataSourceProperties != null && !this.dataSourceProperties.isEmpty()) {
            for (Map.Entry<String, Map<String, String>> entry : this.dataSourceProperties.entrySet()) {
                DataSource dataSource = new DataSourceBuilder(entry.getValue()).build();
                if (flexDataSource == null) {
                    flexDataSource = new FlexDataSource(entry.getKey(), dataSource);
                    continue;
                }
                flexDataSource.addDataSource(entry.getKey(), dataSource);
            }
        }
        return flexDataSource;
    }

    @Bean
    @ConditionalOnMissingBean
    public DataSourceAdvice dataSourceAdvice() {
        return new DataSourceAdvice(new DataSourceInterceptor());
    }
}

