/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.spring.boot;

import com.mybatisflex.core.FlexGlobalConfig;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.ibatis.io.VFS;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.mapping.ResultSetType;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.session.AutoMappingBehavior;
import org.apache.ibatis.session.AutoMappingUnknownColumnBehavior;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.LocalCacheScope;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

@ConfigurationProperties(prefix="mybatis-flex")
public class MybatisFlexProperties {
    private static final ResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver();
    private Map<String, Map<String, String>> datasource;
    private GlobalConfig globalConfig;
    private AdminConfig adminConfig;
    private String configLocation;
    private String[] mapperLocations = new String[]{"classpath*:/mapper/**/*.xml"};
    private String typeAliasesPackage;
    private Class<?> typeAliasesSuperType;
    private String typeHandlersPackage;
    private boolean checkConfigLocation = false;
    private ExecutorType executorType;
    private Class<? extends LanguageDriver> defaultScriptingLanguageDriver;
    private Properties configurationProperties;
    private CoreConfiguration configuration;

    public Map<String, Map<String, String>> getDatasource() {
        return this.datasource;
    }

    public void setDatasource(Map<String, Map<String, String>> datasource) {
        this.datasource = datasource;
    }

    public GlobalConfig getGlobalConfig() {
        return this.globalConfig;
    }

    public void setGlobalConfig(GlobalConfig globalConfig) {
        this.globalConfig = globalConfig;
    }

    public AdminConfig getAdminConfig() {
        return this.adminConfig;
    }

    public void setAdminConfig(AdminConfig adminConfig) {
        this.adminConfig = adminConfig;
    }

    public String getConfigLocation() {
        return this.configLocation;
    }

    public void setConfigLocation(String configLocation) {
        this.configLocation = configLocation;
    }

    public String[] getMapperLocations() {
        return this.mapperLocations;
    }

    public void setMapperLocations(String[] mapperLocations) {
        this.mapperLocations = mapperLocations;
    }

    public String getTypeHandlersPackage() {
        return this.typeHandlersPackage;
    }

    public void setTypeHandlersPackage(String typeHandlersPackage) {
        this.typeHandlersPackage = typeHandlersPackage;
    }

    public String getTypeAliasesPackage() {
        return this.typeAliasesPackage;
    }

    public void setTypeAliasesPackage(String typeAliasesPackage) {
        this.typeAliasesPackage = typeAliasesPackage;
    }

    public Class<?> getTypeAliasesSuperType() {
        return this.typeAliasesSuperType;
    }

    public void setTypeAliasesSuperType(Class<?> typeAliasesSuperType) {
        this.typeAliasesSuperType = typeAliasesSuperType;
    }

    public boolean isCheckConfigLocation() {
        return this.checkConfigLocation;
    }

    public void setCheckConfigLocation(boolean checkConfigLocation) {
        this.checkConfigLocation = checkConfigLocation;
    }

    public ExecutorType getExecutorType() {
        return this.executorType;
    }

    public void setExecutorType(ExecutorType executorType) {
        this.executorType = executorType;
    }

    public Class<? extends LanguageDriver> getDefaultScriptingLanguageDriver() {
        return this.defaultScriptingLanguageDriver;
    }

    public void setDefaultScriptingLanguageDriver(Class<? extends LanguageDriver> defaultScriptingLanguageDriver) {
        this.defaultScriptingLanguageDriver = defaultScriptingLanguageDriver;
    }

    public Properties getConfigurationProperties() {
        return this.configurationProperties;
    }

    public void setConfigurationProperties(Properties configurationProperties) {
        this.configurationProperties = configurationProperties;
    }

    public CoreConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(CoreConfiguration configuration) {
        this.configuration = configuration;
    }

    public Resource[] resolveMapperLocations() {
        return (Resource[])Stream.of((Object[])Optional.ofNullable(this.mapperLocations).orElse(new String[0])).flatMap(location -> Stream.of(this.getResources((String)location))).toArray(Resource[]::new);
    }

    private Resource[] getResources(String location) {
        try {
            return resourceResolver.getResources(location);
        }
        catch (IOException e) {
            return new Resource[0];
        }
    }

    public static class AdminConfig {
        private boolean enable;
        private String endpoint;
        private String secretKey;

        public boolean isEnable() {
            return this.enable;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public String getSecretKey() {
            return this.secretKey;
        }

        public void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }
    }

    public static class GlobalConfig {
        private boolean printBanner = true;
        @NestedConfigurationProperty
        private FlexGlobalConfig.KeyConfig keyConfig;
        private Object normalValueOfLogicDelete = 0;
        private Object deletedValueOfLogicDelete = 1;

        public boolean isPrintBanner() {
            return this.printBanner;
        }

        public void setPrintBanner(boolean printBanner) {
            this.printBanner = printBanner;
        }

        public FlexGlobalConfig.KeyConfig getKeyConfig() {
            return this.keyConfig;
        }

        public void setKeyConfig(FlexGlobalConfig.KeyConfig keyConfig) {
            this.keyConfig = keyConfig;
        }

        public Object getNormalValueOfLogicDelete() {
            return this.normalValueOfLogicDelete;
        }

        public void setNormalValueOfLogicDelete(Object normalValueOfLogicDelete) {
            this.normalValueOfLogicDelete = normalValueOfLogicDelete;
        }

        public Object getDeletedValueOfLogicDelete() {
            return this.deletedValueOfLogicDelete;
        }

        public void setDeletedValueOfLogicDelete(Object deletedValueOfLogicDelete) {
            this.deletedValueOfLogicDelete = deletedValueOfLogicDelete;
        }

        void applyTo(FlexGlobalConfig target) {
            PropertyMapper mapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
            mapper.from((Object)this.isPrintBanner()).to(arg_0 -> ((FlexGlobalConfig)target).setPrintBanner(arg_0));
            mapper.from((Object)this.getKeyConfig()).to(arg_0 -> ((FlexGlobalConfig)target).setKeyConfig(arg_0));
            mapper.from(this.getNormalValueOfLogicDelete()).to(arg_0 -> ((FlexGlobalConfig)target).setNormalValueOfLogicDelete(arg_0));
            mapper.from(this.getDeletedValueOfLogicDelete()).to(arg_0 -> ((FlexGlobalConfig)target).setDeletedValueOfLogicDelete(arg_0));
        }
    }

    public static class CoreConfiguration {
        private Boolean safeRowBoundsEnabled;
        private Boolean safeResultHandlerEnabled;
        private Boolean mapUnderscoreToCamelCase = true;
        private Boolean aggressiveLazyLoading;
        private Boolean multipleResultSetsEnabled;
        private Boolean useGeneratedKeys;
        private Boolean useColumnLabel;
        private Boolean cacheEnabled;
        private Boolean callSettersOnNulls;
        private Boolean useActualParamName;
        private Boolean returnInstanceForEmptyRow;
        private Boolean shrinkWhitespacesInSql;
        private Boolean nullableOnForEach;
        private Boolean argNameBasedConstructorAutoMapping;
        private Boolean lazyLoadingEnabled;
        private Integer defaultStatementTimeout;
        private Integer defaultFetchSize;
        private LocalCacheScope localCacheScope;
        private JdbcType jdbcTypeForNull;
        private ResultSetType defaultResultSetType;
        private ExecutorType defaultExecutorType;
        private AutoMappingBehavior autoMappingBehavior;
        private AutoMappingUnknownColumnBehavior autoMappingUnknownColumnBehavior;
        private String logPrefix;
        private Set<String> lazyLoadTriggerMethods;
        private Class<? extends Log> logImpl;
        private Class<? extends VFS> vfsImpl;
        private Class<?> defaultSqlProviderType;
        Class<? extends TypeHandler> defaultEnumTypeHandler;
        private Class<?> configurationFactory;
        private Properties variables;

        public Boolean getSafeRowBoundsEnabled() {
            return this.safeRowBoundsEnabled;
        }

        public void setSafeRowBoundsEnabled(Boolean safeRowBoundsEnabled) {
            this.safeRowBoundsEnabled = safeRowBoundsEnabled;
        }

        public Boolean getSafeResultHandlerEnabled() {
            return this.safeResultHandlerEnabled;
        }

        public void setSafeResultHandlerEnabled(Boolean safeResultHandlerEnabled) {
            this.safeResultHandlerEnabled = safeResultHandlerEnabled;
        }

        public Boolean getMapUnderscoreToCamelCase() {
            return this.mapUnderscoreToCamelCase;
        }

        public void setMapUnderscoreToCamelCase(Boolean mapUnderscoreToCamelCase) {
            this.mapUnderscoreToCamelCase = mapUnderscoreToCamelCase;
        }

        public Boolean getAggressiveLazyLoading() {
            return this.aggressiveLazyLoading;
        }

        public void setAggressiveLazyLoading(Boolean aggressiveLazyLoading) {
            this.aggressiveLazyLoading = aggressiveLazyLoading;
        }

        public Boolean getMultipleResultSetsEnabled() {
            return this.multipleResultSetsEnabled;
        }

        public void setMultipleResultSetsEnabled(Boolean multipleResultSetsEnabled) {
            this.multipleResultSetsEnabled = multipleResultSetsEnabled;
        }

        public Boolean getUseGeneratedKeys() {
            return this.useGeneratedKeys;
        }

        public void setUseGeneratedKeys(Boolean useGeneratedKeys) {
            this.useGeneratedKeys = useGeneratedKeys;
        }

        public Boolean getUseColumnLabel() {
            return this.useColumnLabel;
        }

        public void setUseColumnLabel(Boolean useColumnLabel) {
            this.useColumnLabel = useColumnLabel;
        }

        public Boolean getCacheEnabled() {
            return this.cacheEnabled;
        }

        public void setCacheEnabled(Boolean cacheEnabled) {
            this.cacheEnabled = cacheEnabled;
        }

        public Boolean getCallSettersOnNulls() {
            return this.callSettersOnNulls;
        }

        public void setCallSettersOnNulls(Boolean callSettersOnNulls) {
            this.callSettersOnNulls = callSettersOnNulls;
        }

        public Boolean getUseActualParamName() {
            return this.useActualParamName;
        }

        public void setUseActualParamName(Boolean useActualParamName) {
            this.useActualParamName = useActualParamName;
        }

        public Boolean getReturnInstanceForEmptyRow() {
            return this.returnInstanceForEmptyRow;
        }

        public void setReturnInstanceForEmptyRow(Boolean returnInstanceForEmptyRow) {
            this.returnInstanceForEmptyRow = returnInstanceForEmptyRow;
        }

        public Boolean getShrinkWhitespacesInSql() {
            return this.shrinkWhitespacesInSql;
        }

        public void setShrinkWhitespacesInSql(Boolean shrinkWhitespacesInSql) {
            this.shrinkWhitespacesInSql = shrinkWhitespacesInSql;
        }

        public Boolean getNullableOnForEach() {
            return this.nullableOnForEach;
        }

        public void setNullableOnForEach(Boolean nullableOnForEach) {
            this.nullableOnForEach = nullableOnForEach;
        }

        public Boolean getArgNameBasedConstructorAutoMapping() {
            return this.argNameBasedConstructorAutoMapping;
        }

        public void setArgNameBasedConstructorAutoMapping(Boolean argNameBasedConstructorAutoMapping) {
            this.argNameBasedConstructorAutoMapping = argNameBasedConstructorAutoMapping;
        }

        public String getLogPrefix() {
            return this.logPrefix;
        }

        public void setLogPrefix(String logPrefix) {
            this.logPrefix = logPrefix;
        }

        public Class<? extends Log> getLogImpl() {
            return this.logImpl;
        }

        public void setLogImpl(Class<? extends Log> logImpl) {
            this.logImpl = logImpl;
        }

        public Class<? extends VFS> getVfsImpl() {
            return this.vfsImpl;
        }

        public void setVfsImpl(Class<? extends VFS> vfsImpl) {
            this.vfsImpl = vfsImpl;
        }

        public Class<?> getDefaultSqlProviderType() {
            return this.defaultSqlProviderType;
        }

        public void setDefaultSqlProviderType(Class<?> defaultSqlProviderType) {
            this.defaultSqlProviderType = defaultSqlProviderType;
        }

        public LocalCacheScope getLocalCacheScope() {
            return this.localCacheScope;
        }

        public void setLocalCacheScope(LocalCacheScope localCacheScope) {
            this.localCacheScope = localCacheScope;
        }

        public JdbcType getJdbcTypeForNull() {
            return this.jdbcTypeForNull;
        }

        public void setJdbcTypeForNull(JdbcType jdbcTypeForNull) {
            this.jdbcTypeForNull = jdbcTypeForNull;
        }

        public Set<String> getLazyLoadTriggerMethods() {
            return this.lazyLoadTriggerMethods;
        }

        public void setLazyLoadTriggerMethods(Set<String> lazyLoadTriggerMethods) {
            this.lazyLoadTriggerMethods = lazyLoadTriggerMethods;
        }

        public Integer getDefaultStatementTimeout() {
            return this.defaultStatementTimeout;
        }

        public void setDefaultStatementTimeout(Integer defaultStatementTimeout) {
            this.defaultStatementTimeout = defaultStatementTimeout;
        }

        public Integer getDefaultFetchSize() {
            return this.defaultFetchSize;
        }

        public void setDefaultFetchSize(Integer defaultFetchSize) {
            this.defaultFetchSize = defaultFetchSize;
        }

        public ResultSetType getDefaultResultSetType() {
            return this.defaultResultSetType;
        }

        public void setDefaultResultSetType(ResultSetType defaultResultSetType) {
            this.defaultResultSetType = defaultResultSetType;
        }

        public ExecutorType getDefaultExecutorType() {
            return this.defaultExecutorType;
        }

        public void setDefaultExecutorType(ExecutorType defaultExecutorType) {
            this.defaultExecutorType = defaultExecutorType;
        }

        public AutoMappingBehavior getAutoMappingBehavior() {
            return this.autoMappingBehavior;
        }

        public void setAutoMappingBehavior(AutoMappingBehavior autoMappingBehavior) {
            this.autoMappingBehavior = autoMappingBehavior;
        }

        public AutoMappingUnknownColumnBehavior getAutoMappingUnknownColumnBehavior() {
            return this.autoMappingUnknownColumnBehavior;
        }

        public void setAutoMappingUnknownColumnBehavior(AutoMappingUnknownColumnBehavior autoMappingUnknownColumnBehavior) {
            this.autoMappingUnknownColumnBehavior = autoMappingUnknownColumnBehavior;
        }

        public Properties getVariables() {
            return this.variables;
        }

        public void setVariables(Properties variables) {
            this.variables = variables;
        }

        public Boolean getLazyLoadingEnabled() {
            return this.lazyLoadingEnabled;
        }

        public void setLazyLoadingEnabled(Boolean lazyLoadingEnabled) {
            this.lazyLoadingEnabled = lazyLoadingEnabled;
        }

        public Class<?> getConfigurationFactory() {
            return this.configurationFactory;
        }

        public void setConfigurationFactory(Class<?> configurationFactory) {
            this.configurationFactory = configurationFactory;
        }

        public Class<? extends TypeHandler> getDefaultEnumTypeHandler() {
            return this.defaultEnumTypeHandler;
        }

        public void setDefaultEnumTypeHandler(Class<? extends TypeHandler> defaultEnumTypeHandler) {
            this.defaultEnumTypeHandler = defaultEnumTypeHandler;
        }

        void applyTo(Configuration target) {
            PropertyMapper mapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
            mapper.from((Object)this.getSafeRowBoundsEnabled()).to(arg_0 -> ((Configuration)target).setSafeRowBoundsEnabled(arg_0));
            mapper.from((Object)this.getSafeResultHandlerEnabled()).to(arg_0 -> ((Configuration)target).setSafeResultHandlerEnabled(arg_0));
            mapper.from((Object)this.getMapUnderscoreToCamelCase()).to(arg_0 -> ((Configuration)target).setMapUnderscoreToCamelCase(arg_0));
            mapper.from((Object)this.getAggressiveLazyLoading()).to(arg_0 -> ((Configuration)target).setAggressiveLazyLoading(arg_0));
            mapper.from((Object)this.getMultipleResultSetsEnabled()).to(arg_0 -> ((Configuration)target).setMultipleResultSetsEnabled(arg_0));
            mapper.from((Object)this.getUseGeneratedKeys()).to(arg_0 -> ((Configuration)target).setUseGeneratedKeys(arg_0));
            mapper.from((Object)this.getUseColumnLabel()).to(arg_0 -> ((Configuration)target).setUseColumnLabel(arg_0));
            mapper.from((Object)this.getCacheEnabled()).to(arg_0 -> ((Configuration)target).setCacheEnabled(arg_0));
            mapper.from((Object)this.getCallSettersOnNulls()).to(arg_0 -> ((Configuration)target).setCallSettersOnNulls(arg_0));
            mapper.from((Object)this.getUseActualParamName()).to(arg_0 -> ((Configuration)target).setUseActualParamName(arg_0));
            mapper.from((Object)this.getReturnInstanceForEmptyRow()).to(arg_0 -> ((Configuration)target).setReturnInstanceForEmptyRow(arg_0));
            mapper.from((Object)this.getShrinkWhitespacesInSql()).to(arg_0 -> ((Configuration)target).setShrinkWhitespacesInSql(arg_0));
            mapper.from((Object)this.getNullableOnForEach()).to(arg_0 -> ((Configuration)target).setNullableOnForEach(arg_0));
            mapper.from((Object)this.getArgNameBasedConstructorAutoMapping()).to(arg_0 -> ((Configuration)target).setArgNameBasedConstructorAutoMapping(arg_0));
            mapper.from((Object)this.getLazyLoadingEnabled()).to(arg_0 -> ((Configuration)target).setLazyLoadingEnabled(arg_0));
            mapper.from((Object)this.getLogPrefix()).to(arg_0 -> ((Configuration)target).setLogPrefix(arg_0));
            mapper.from(this.getLazyLoadTriggerMethods()).to(arg_0 -> ((Configuration)target).setLazyLoadTriggerMethods(arg_0));
            mapper.from((Object)this.getDefaultStatementTimeout()).to(arg_0 -> ((Configuration)target).setDefaultStatementTimeout(arg_0));
            mapper.from((Object)this.getDefaultFetchSize()).to(arg_0 -> ((Configuration)target).setDefaultFetchSize(arg_0));
            mapper.from((Object)this.getLocalCacheScope()).to(arg_0 -> ((Configuration)target).setLocalCacheScope(arg_0));
            mapper.from((Object)this.getJdbcTypeForNull()).to(arg_0 -> ((Configuration)target).setJdbcTypeForNull(arg_0));
            mapper.from((Object)this.getDefaultResultSetType()).to(arg_0 -> ((Configuration)target).setDefaultResultSetType(arg_0));
            mapper.from((Object)this.getDefaultExecutorType()).to(arg_0 -> ((Configuration)target).setDefaultExecutorType(arg_0));
            mapper.from((Object)this.getAutoMappingBehavior()).to(arg_0 -> ((Configuration)target).setAutoMappingBehavior(arg_0));
            mapper.from((Object)this.getAutoMappingUnknownColumnBehavior()).to(arg_0 -> ((Configuration)target).setAutoMappingUnknownColumnBehavior(arg_0));
            mapper.from((Object)this.getVariables()).to(arg_0 -> ((Configuration)target).setVariables(arg_0));
            mapper.from(this.getLogImpl()).to(arg_0 -> ((Configuration)target).setLogImpl(arg_0));
            mapper.from(this.getVfsImpl()).to(arg_0 -> ((Configuration)target).setVfsImpl(arg_0));
            mapper.from(this.getDefaultSqlProviderType()).to(arg_0 -> ((Configuration)target).setDefaultSqlProviderType(arg_0));
            mapper.from(this.getConfigurationFactory()).to(arg_0 -> ((Configuration)target).setConfigurationFactory(arg_0));
            mapper.from(this.getDefaultEnumTypeHandler()).to(arg_0 -> ((Configuration)target).setDefaultEnumTypeHandler(arg_0));
        }
    }
}

