/*
 * Decompiled with CFR 0.152.
 */
package com.raincat.dubbo.sample.order.service.impl;

import com.raincat.core.annotation.TxTransaction;
import com.raincat.dubbo.sample.order.api.entity.Order;
import com.raincat.dubbo.sample.order.api.service.OrderService;
import com.raincat.dubbo.sample.order.mapper.OrderMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="orderService")
public class OrderServiceImpl
implements OrderService {
    private final OrderMapper orderMapper;

    @Autowired
    public OrderServiceImpl(OrderMapper orderMapper) {
        this.orderMapper = orderMapper;
    }

    @TxTransaction
    public void save(Order order) {
        this.orderMapper.save(order);
    }

    @TxTransaction
    public void fail(Order order) throws RuntimeException {
        this.orderMapper.save(null);
    }

    @TxTransaction
    public void timeOut(Order order) {
        this.orderMapper.save(order);
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

