package com.raincat.springcloud.configuration;

import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import com.raincat.springcloud.feign.RestTemplateInterceptor;
import com.raincat.springcloud.hystrix.RaincatHystrixConcurrencyStrategy;
import feign.RequestInterceptor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * RestTemplateConfiguration.
 *
 * @author xiaoyu
 */
@Configuration
public class RaincatFeignConfiguration {

    /**
     * Request interceptor request interceptor.
     *
     * @return the request interceptor
     */
    @Bean
    public RequestInterceptor requestInterceptor() {
        return new RestTemplateInterceptor();
    }

    /**
     * Hystrix concurrency strategy hystrix concurrency strategy.
     *
     * @return the hystrix concurrency strategy
     */
    @Bean
    @ConditionalOnProperty(name = "feign.hystrix.enabled")
    public HystrixConcurrencyStrategy hystrixConcurrencyStrategy() {
        return new RaincatHystrixConcurrencyStrategy();
    }

}