/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.dynamic.intercept;

import io.lettuce.core.dynamic.intercept.MethodInterceptor;
import io.lettuce.core.dynamic.intercept.MethodInterceptorChain;
import io.lettuce.core.internal.AbstractInvocationHandler;
import io.lettuce.core.internal.LettuceAssert;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;

public class InvocationProxyFactory {
    private final List<MethodInterceptor> interceptors = new ArrayList<MethodInterceptor>();
    private final List<Class<?>> interfaces = new ArrayList();

    public <T> T createProxy(ClassLoader classLoader) {
        LettuceAssert.notNull((Object)classLoader, "ClassLoader must not be null");
        Class[] interfaces = this.interfaces.toArray(new Class[0]);
        return (T)Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)new InterceptorChainInvocationHandler(this.interceptors));
    }

    public void addInterface(Class<?> ifc) {
        LettuceAssert.notNull(ifc, "Interface type must not be null");
        LettuceAssert.isTrue(ifc.isInterface(), "Type must be an interface");
        this.interfaces.add(ifc);
    }

    public void addInterceptor(MethodInterceptor interceptor) {
        LettuceAssert.notNull((Object)interceptor, "MethodInterceptor must not be null");
        this.interceptors.add(interceptor);
    }

    static class InterceptorChainInvocationHandler
    extends AbstractInvocationHandler {
        private final MethodInterceptorChain.Head context;

        InterceptorChainInvocationHandler(List<MethodInterceptor> interceptors) {
            this.context = MethodInterceptorChain.from(interceptors);
        }

        @Override
        protected Object handleInvocation(Object proxy, Method method, Object[] args) throws Throwable {
            return this.context.invoke(proxy, method, args);
        }
    }
}

