/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.function;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.measure.Prefix;
import javax.measure.UnitConverter;
import tech.units.indriya.function.Calculus;
import tech.units.indriya.function.DefaultNumberSystem;
import tech.units.indriya.function.IdentityMultiplyConverter;
import tech.units.indriya.function.PowerOfIntConverter;
import tech.units.indriya.function.PowerOfPiConverter;
import tech.units.indriya.function.RationalConverter;
import tech.units.indriya.function.RationalNumber;
import tech.units.indriya.spi.NumberSystem;
import tech.uom.lib.common.function.Converter;
import tech.uom.lib.common.function.FactorSupplier;
import tech.uom.lib.common.function.ValueSupplier;

public interface MultiplyConverter
extends UnitConverter,
Converter<Number, Number>,
ValueSupplier<Number>,
FactorSupplier<Number>,
Comparable<UnitConverter> {
    public static MultiplyConverter ofRational(RationalNumber factor) {
        if (factor.equals(RationalNumber.ONE)) {
            return MultiplyConverter.identity();
        }
        return RationalConverter.of(factor);
    }

    public static MultiplyConverter ofRational(long dividend, long divisor) {
        RationalNumber rational = RationalNumber.of(dividend, divisor);
        return MultiplyConverter.ofRational(rational);
    }

    public static MultiplyConverter ofRational(BigInteger dividend, BigInteger divisor) {
        RationalNumber rational = RationalNumber.of(dividend, divisor);
        return MultiplyConverter.ofRational(rational);
    }

    public static MultiplyConverter of(Number factor) {
        NumberSystem ns = Calculus.currentNumberSystem();
        if (ns.isOne(factor)) {
            return MultiplyConverter.identity();
        }
        Number narrowedFactor = ns.narrow(factor);
        if (narrowedFactor instanceof RationalNumber) {
            return MultiplyConverter.ofRational((RationalNumber)narrowedFactor);
        }
        if (ns.isInteger(narrowedFactor)) {
            if (narrowedFactor instanceof BigInteger) {
                return MultiplyConverter.ofRational(RationalNumber.ofInteger((BigInteger)narrowedFactor));
            }
            if (!(ns instanceof DefaultNumberSystem)) {
                throw new UnsupportedOperationException("not yet supported");
            }
            return MultiplyConverter.ofRational(RationalNumber.ofInteger(narrowedFactor.longValue()));
        }
        if (narrowedFactor instanceof Double || narrowedFactor instanceof Float) {
            return MultiplyConverter.of(narrowedFactor.doubleValue());
        }
        if (narrowedFactor instanceof BigDecimal) {
            BigDecimal decimal = (BigDecimal)narrowedFactor;
            RationalNumber rational = RationalNumber.of(decimal);
            return MultiplyConverter.ofRational(rational);
        }
        throw new UnsupportedOperationException("not yet supported");
    }

    public static MultiplyConverter of(double factor) {
        if (factor == 0.0) {
            return MultiplyConverter.identity();
        }
        RationalNumber rational = RationalNumber.of(factor);
        return MultiplyConverter.ofRational(rational);
    }

    public static MultiplyConverter ofPrefix(Prefix prefix) {
        if (prefix == null) {
            return MultiplyConverter.identity();
        }
        if (prefix.getExponent() == 1) {
            return MultiplyConverter.of(prefix.getValue());
        }
        return PowerOfIntConverter.of(prefix);
    }

    public static MultiplyConverter ofPiExponent(int exponent) {
        if (exponent == 0) {
            return MultiplyConverter.identity();
        }
        return PowerOfPiConverter.of(exponent);
    }

    public static MultiplyConverter ofExponent(int base, int exponent) {
        if (exponent == 0) {
            return MultiplyConverter.identity();
        }
        return PowerOfIntConverter.of(base, exponent);
    }

    public static MultiplyConverter ofTenExponent(int exponent) {
        if (exponent == 0) {
            return MultiplyConverter.identity();
        }
        return PowerOfIntConverter.of(10, exponent);
    }

    public static MultiplyConverter identity() {
        return IdentityMultiplyConverter.INSTANCE;
    }

    default public boolean isLinear() {
        return true;
    }

    default public Number getFactor() {
        return (Number)this.getValue();
    }
}

