/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.fieldtypes;

import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.common.ByteConversions;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.fieldtypes.FieldType;

public class FieldTypeDouble
extends FieldType {
    public FieldTypeDouble(int type, String name) {
        super(type, name, 8);
    }

    @Override
    public Object getValue(TiffField entry) {
        byte[] bytes = entry.getByteArrayValue();
        if (entry.getCount() == 1L) {
            return ByteConversions.toDouble(bytes, entry.getByteOrder());
        }
        return ByteConversions.toDoubles(bytes, entry.getByteOrder());
    }

    @Override
    public byte[] writeData(Object o, ByteOrder byteOrder) throws ImageWriteException {
        if (o instanceof Double) {
            return ByteConversions.toBytes((Double)o, byteOrder);
        }
        if (o instanceof double[]) {
            return ByteConversions.toBytes((double[])o, byteOrder);
        }
        if (!(o instanceof Double[])) {
            throw new ImageWriteException("Invalid data", o);
        }
        double[] values = new double[((Double[])o).length];
        Arrays.setAll(values, i -> ((Double[])o)[i]);
        return ByteConversions.toBytes(values, byteOrder);
    }
}

