/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff;

import org.apache.commons.imaging.common.XmpImagingParameters;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.PhotometricInterpreter;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputSet;

public class TiffImagingParameters
extends XmpImagingParameters {
    private boolean readThumbnails = true;
    private TiffOutputSet tiffOutputSet = null;
    private int subImageX;
    private int subImageY;
    private int subImageWidth;
    private int subImageHeight;
    private PhotometricInterpreter customPhotometricInterpreter = null;
    private Integer compression = null;
    private Integer lzwCompressionBlockSize = null;
    private Integer t4Options = null;
    private Integer t6Options = null;

    public boolean isReadThumbnails() {
        return this.readThumbnails;
    }

    public void setReadThumbnails(boolean readThumbnails) {
        this.readThumbnails = readThumbnails;
    }

    public TiffOutputSet getOutputSet() {
        return this.tiffOutputSet;
    }

    public void setOutputSet(TiffOutputSet tiffOutputSet) {
        this.tiffOutputSet = tiffOutputSet;
    }

    public void setSubImage(int x, int y, int width, int height) {
        if (x < 0 || y < 0) {
            throw new IllegalArgumentException("Invalid sub-image specification: negative x and y values not allowed");
        }
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Invalid sub-image specification width and height must be greater than zero");
        }
        this.subImageX = x;
        this.subImageY = y;
        this.subImageWidth = width;
        this.subImageHeight = height;
    }

    public void clearSubImage() {
        this.subImageWidth = 0;
        this.subImageHeight = 0;
    }

    public boolean isSubImageSet() {
        return this.subImageWidth > 0 && this.subImageHeight > 0;
    }

    public int getSubImageX() {
        return this.subImageX;
    }

    public int getSubImageY() {
        return this.subImageY;
    }

    public int getSubImageWidth() {
        return this.subImageWidth;
    }

    public int getSubImageHeight() {
        return this.subImageHeight;
    }

    public PhotometricInterpreter getCustomPhotometricInterpreter() {
        return this.customPhotometricInterpreter;
    }

    public void setCustomPhotometricInterpreter(PhotometricInterpreter customPhotometricInterpreter) {
        this.customPhotometricInterpreter = customPhotometricInterpreter;
    }

    public Integer getCompression() {
        return this.compression;
    }

    public void setCompression(Integer compression) {
        this.compression = compression;
    }

    public Integer getLzwCompressionBlockSize() {
        return this.lzwCompressionBlockSize;
    }

    public void setLzwCompressionBlockSize(Integer lzwCompressionBlockSize) {
        this.lzwCompressionBlockSize = lzwCompressionBlockSize;
    }

    public Integer getT4Options() {
        return this.t4Options;
    }

    public void setT4Options(Integer t4Options) {
        this.t4Options = t4Options;
    }

    public Integer getT6Options() {
        return this.t6Options;
    }

    public void setT6Options(Integer t6Options) {
        this.t6Options = t6Options;
    }
}

