/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.bytesource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.imaging.bytesource.ByteSourceArray;
import org.apache.commons.imaging.bytesource.ByteSourceFile;
import org.apache.commons.imaging.bytesource.ByteSourceInputStream;
import org.apache.commons.imaging.common.BinaryFunctions;

public abstract class ByteSource {
    private final String fileName;

    public static ByteSource array(byte[] array) {
        return new ByteSourceArray(array);
    }

    public static ByteSource array(byte[] array, String name) {
        return new ByteSourceArray(array, name);
    }

    public static ByteSource file(File file) {
        return new ByteSourceFile(file);
    }

    public static ByteSource file(String file) {
        return ByteSource.file(new File(file));
    }

    public static ByteSource inputStream(InputStream is, String name) {
        return new ByteSourceInputStream(is, name);
    }

    public ByteSource(String fileName) {
        this.fileName = fileName;
    }

    public abstract byte[] getBlock(long var1, int var3) throws IOException;

    public abstract String getDescription();

    public final String getFileName() {
        return this.fileName;
    }

    public abstract InputStream getInputStream() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final InputStream getInputStream(long start) throws IOException {
        InputStream is = null;
        boolean succeeded = false;
        try {
            is = this.getInputStream();
            BinaryFunctions.skipBytes(is, start);
            succeeded = true;
        }
        finally {
            if (!succeeded && is != null) {
                is.close();
            }
        }
        return is;
    }

    public abstract long getLength() throws IOException;

    public boolean isFile() {
        return false;
    }
}

