/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.bytesource;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;

class ByteSourceArray
extends ByteSource {
    private final byte[] bytes;

    ByteSourceArray(byte[] bytes) {
        this(bytes, null);
    }

    ByteSourceArray(byte[] bytes, String fileName) {
        super(fileName);
        this.bytes = bytes;
    }

    @Override
    public byte[] getBlock(long from, int length) throws ImagingException {
        int start;
        try {
            start = Math.toIntExact(from);
        }
        catch (ArithmeticException e) {
            throw new ImagingException(e);
        }
        if (start < 0 || length < 0 || start + length < 0 || start + length > this.bytes.length) {
            throw new ImagingException("Could not read block (block start: " + start + ", block length: " + length + ", data length: " + this.bytes.length + ").");
        }
        return Arrays.copyOfRange(this.bytes, start, start + length);
    }

    @Override
    public String getDescription() {
        return this.bytes.length + " byte array";
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.bytes);
    }

    @Override
    public long getLength() {
        return this.bytes.length;
    }
}

