/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.bytesource;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.common.BinaryFunctions;

class ByteSourceFile
extends ByteSource {
    private final File file;

    ByteSourceFile(File file) {
        super(file.getName());
        this.file = file;
    }

    @Override
    public byte[] getBlock(long from, int length) throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(this.file, "r");){
            if (from < 0L || length < 0 || from + (long)length < 0L || from + (long)length > raf.length()) {
                throw new ImagingException("Could not read block (block start: " + from + ", block length: " + length + ", data length: " + raf.length() + ").");
            }
            byte[] byArray = BinaryFunctions.getRAFBytes(raf, from, length, "Could not read value from file");
            return byArray;
        }
    }

    @Override
    public String getDescription() {
        return "File: '" + this.file.getAbsolutePath() + "'";
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new BufferedInputStream(new FileInputStream(this.file));
    }

    @Override
    public long getLength() {
        return this.file.length();
    }

    @Override
    public boolean isFile() {
        return true;
    }
}

