/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.common;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.Allocator;

public class ZlibDeflate {
    public static byte[] compress(byte[] bytes) throws ImagingException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(Allocator.checkByteArray(bytes.length / 2));
        try (DeflaterOutputStream compressOut = new DeflaterOutputStream(out);){
            compressOut.write(bytes);
        }
        catch (IOException e) {
            throw new ImagingException("Unable to compress image", e);
        }
        return out.toByteArray();
    }

    public static byte[] decompress(byte[] bytes, int expectedSize) throws ImagingException {
        try {
            Inflater inflater = new Inflater();
            inflater.setInput(bytes);
            byte[] result = Allocator.byteArray(expectedSize);
            inflater.inflate(result);
            return result;
        }
        catch (DataFormatException e) {
            throw new ImagingException("Unable to decompress image", e);
        }
    }
}

